function [dag, score] = computeOptimalDag2(scores)
% Finds an optimal DAG given local scores
%
% Input:
% scores	Local scores (an n \times 2^n matrix)
%
% Output:
% dag		An optimal DAG
% score		The score of the optimal DAG
%
% This function is derived from the source code by Daniel Eaton and Kevin Murphy.

bps = findBestParents(scores);
[sinks, score] = findBestSinks2(bps, scores);
order = findBestOrdering(sinks);
parents = findBestNetwork(order, bps);

dag = parentsToDag(parents); 
