function [optimal_dag, optimal_score, vc, t] = find_bounded_vertex_cover_dag(scores, k)
% Find an optimal DAG with vertex cover bound at most k
% Parameters:
% scores  		n \times 2^n matrix of local scores
% k       		vertex cover number bound
% Returns:
% optimal_dag		An optimal DAG in a matrix form
% optimal_score		The score of the optimal DAG
% t               	Running time (in seconds)

tic;
t1 = toc;

n = length(scores(:, 1));
optimal_dag = zeros(n, n);
optimal_score = -Inf;
vc = [];

base_set1 = 1:n;
N1 = base_set1(1:k);

% Loop though all vertex covers
while ~isempty(N1)
    [bss, bps] = choose_parents_from_vertex_cover(scores, N1);
    base_set2 = setdiff(base_set1, N1);
    if length(base_set2) >= k
        N2 = base_set2(1:k);
    else
        N2 = base_set2;
    end
    % Loop through all possible parents outside vertex cover
    while ~isempty(N2)
	% Step 1
        % Find an optimal DAG for the union of N1 and N2 
        new_scores = prune_parent_sets(scores, N1, N2);
        [temp_dag, temp_score] = computeOptimalDag2(new_scores); 
        dag = zeros(n, n);
        comb = [N1 N2];
        m = length(comb);
        for i = 1:m
           ind = find(temp_dag(:, i));
           for j = ind
              dag(comb(j), comb(i)) = 1; 
           end
        end
        score = temp_score;
	% Step 2
	% Find optimal parents for the rest of nodes 
        for i = 1:length(base_set2)
            if ~ismember(base_set2(i), N2)
                score = score + bss(i);
                parents = find(bitget(bps(i) - 1, 1:n));
                for j = parents
                    dag(j, base_set2(i)) = 1;
                end
            end
        end
	% Step 3
	% Check whether the score improves
        if score > optimal_score
            optimal_score = score;
            optimal_dag = dag;
            vc = N1;
        end
        if length(base_set2) > k
            N2 = next_set(base_set2, k, N2); % New parent set
        else
            N2 = [];
        end
    end
    N1 = next_set(base_set1, k, N1); % New vertex cover
end

t2 = toc;
t = t2 - t1;

end
