function [ ns ] = next_set( base_set, k, current_set )
% Iterates over k element subsets of base_set in a canonical order. Outputs the set that follows current_set. If current_set is empty, the first set in the canonical order is returned. If the current_set is the last set in the order then an empty set is returned.
%
% Input:
% base_set	The base set	
% k		Size of the subsets
% current_set	The current set
%
% Output:
% ns		The set that follows current_set in the canonical order
%

n = length(base_set);
ns = [];
add = 0;
if ~isempty(current_set)
    ind = find(base_set == current_set(1));
end

if isempty(current_set)
   ns = base_set(1:k);
elseif ind > n - k
    return % Last set
else
   if k == 1
       ns = base_set(ind + 1);
   else
       remove = 1;
       while remove == 1 && length(current_set) > 1
          ind = find(base_set == current_set(end));
          if ind < n - k + length(current_set)
             current_set = setdiff(current_set, current_set(end));
             current_set = [current_set base_set(ind + 1)];
             remove = 0;
             add = 1;
          else
             current_set = setdiff(current_set, current_set(end));
          end
       end
       if length(current_set) < k
           ind = find(base_set == current_set(end));
           if ind <= n - (k - length(current_set))
              if add == 0
                  current_set = setdiff(current_set, current_set(end));
                  current_set = [current_set base_set(ind + 1)];
              end
              while length(current_set) < k
                ind = find(base_set == current_set(end));
                current_set = [current_set base_set(ind + 1)];
              end
           else
               return % Last set
           end
       end
       ns = current_set;
   end
end


end

