function [ new_scores ] = prune_parent_sets( scores, N1, N2 )
% Prunes possible parent sets for the variables in the vertex cover N1 or possible parents of the vertex cover variables N2 (Lemma 3)
%
% Input:
% scores	Local scores (n * 2^n matrix)
% N1		Vertex cover
% N2		Potential parents of vertex cover variables
%
% Output:
% new_scores	Pruned local scores

n = length(scores(:, 1));
k = length(N1);
m = length(N2);
t = m + k;
S = [N1 N2];

new_scores = Inf*ones(t, 2^t);

for i = 1:2^t
    bits = bitget(i - 1, 1:t);
    vars = S(find(bits));
    ind = sum(bitset(0, vars, 1)) + 1;
    % Variables in vertex cover
    for j = 1:k
        if sum(bits(k+1:t))>1 % There is more than one parent from D
            new_scores(j, i) = -Inf;
        else
            new_scores(j, i) = scores(N1(j), ind);
        end
    end
    % Parents of vertex cover
    for j = k+1:t
        if sum(bits(k+1:t))>0 % There are parents from D
            new_scores(j, i) = -Inf;
        else
            new_scores(j, i) = scores(N2(j - k), ind);
        end
    end
end

