# Prepares input for Anduril KM Survival association module.


load(file.path(res_dir,"topModels.RData"))
load(file.path(dat_dir,"preprocessed","clinical_info.RData"))

Zs = Zs[-(which(!(rownames(Zs) %in% rownames(clinpat)))),] #Patient mapping

#Form patient groups for each ROI: gene.
quant = apply(t(Zs), 1,  quantile, probs= c(.10,.90), na.rm=T) #Identify quantiles for each ROI: (region of interest or gene that is found to have high dependence from simcca)
neg = apply(t(quant),1,function(x)  abs(x[1]) > x[2] ) #if we wish to form two groups
patgp = list()
for(i in 1:length(neg)) {
        patgp[[i]] = list()
        patgp[[i]]$gp1 = names(which(Zs[,i] <= quant[1,i]))
        patgp[[i]]$gp2 = names(which(Zs[,i] >= quant[2,i]))
        patgp[[i]]$contorl = names(which(Zs[,i] < quant[2,i] & Zs[,i] > quant[1,i]))
        patgp[[i]]$gpna = names(which(is.na(Zs[,i])))#
}
#Form input for Anduril Kaplan Meier survival analysis
#columns Id, followup, vitalstatus and groups

annot = matrix(0,dim(clinpat)[1],3)
colnames(annot) = c("ID","FollowUp","VitalStatus")
annot[,1] = rownames(clinpat)

annot[,2] = as.vector(clinpat$days_to_death)
indna = which(clinpat$days_to_death == "null")
annot[indna,2] = as.vector(clinpat$days_to_last_followup[indna])
annot[,2] = replace(annot[,2],which(annot[,2] == "null"),"NA")
clinpat$days_to_last_followup[which(clinpat$days_to_last_followup == "null")] = NA
#The above establishes the censorship for KM analysis. i.e. it considers the two cases where either the patient dies or leaves the study

annot[,3] = as.vector(clinpat$vital_status)
annot[,3] = replace(annot[,3],which(annot[,3] == "DECEASED"), 1) #Eevent occurance
annot[,3] = replace(annot[,3],which(annot[,3] == "LIVING"), 0)  #Censoring
annot[,3] = replace(annot[,3],which(annot[,3] == "null"), "NA")
rownames(annot) = annot[,1]

mat_patgp = matrix(NA,dim(Zs)[1],dim(Zs)[2])
for(i in 1:length(neg)) {
        mat_patgp[as.vector(which(Zs[,i] <=quant[1,i])),i] = "Neg_Affect"
        mat_patgp[as.vector(which(Zs[,i] >= quant[2,i])),i] = "Pos_Affect"
        mat_patgp[as.vector(which(Zs[,i] < quant[2,i] & Zs[,i] > quant[1,i])), i] = "No_Affect"
}
rownames(mat_patgp) = rownames(Zs)

inp = merge(annot,mat_patgp,by="row.names")

inp = inp[,-1]
colnames(inp)[4:dim(inp)[2]] = colnames(Zs)
inp = inp[-c(which(inp$VitalStatus == "NA")),]

write.table(inp, file=file.path(current_rundir,"anduril_input_file.txt"),row.names=FALSE, sep="\t", quote = FALSE) #Input file for Anduril KM analysis
#write.table(inp[,1:6], file="survival2.txt",row.names=FALSE, sep="\t",quote = FALSE) #just for testing
#write.csv(t(colnames(inp)[4:dim(inp)[2]]), file = paste(current_rundir, "ROI_names.csv",sep=""), row.names = FALSE, quote = FALSE,sep=" ") # For setting group names in Anduril scripts
## FOR ANDURIL Read and execute commands mentioned in KM_Anduril_Analysis.txt"


