learn.GBLUP.pars <- function(model.inputs, g.ker.sel, method) {

print('learning GBLUP pars')


###########################################
# put inputs to format required by rrBLUP #
###########################################

# list all genotypes

  # all genotypes, including validation and test sets
  genotyypit <- rownames(model.inputs$geno.kernels$train[[g.ker.sel]])
  kaikki.genotyypit <- rownames(model.inputs$extra.kernels$full.genotype.kernel[[g.ker.sel]])
  



  # check:
  #genotyypit.test <- c(rownames(model.inputs$geno.kernels$train[[1]]), rownames(model.inputs$geno.kernels$valid[[1]]), rownames(model.inputs$geno.kernels$test[[1]]))
  #genotyypit2.test<-rownames(model.inputs$extra.kernels$full.genotype.kernel[[1]])
  #all(genotyypit.test== genotyypit2.test)
  # OK

  
  # column key containing also validation and test sets
  #col.key.tmp <- cbind(model.inputs$pheno.data$train$column.key, model.inputs$pheno.data$valid$column.key, model.inputs$pheno.data$test$column.key)

  ##########################################################
  # this code was written to work with multiple phenotypes #
  ##########################################################
  #
  #-hence, always loop all phenotypes in the training set

  fenotyypit <- unique(model.inputs$pheno.data$train$column.key['fenotyyppi',])
  GBLUP.preds <- array(NA,dim=c(length(kaikki.genotyypit), length(fenotyypit)))
  dimnames(GBLUP.preds) <- list(kaikki.genotyypit,fenotyypit)
  
  time.start <- proc.time()[[3]]
  
  for (feno in fenotyypit) {
    
    print(feno)
    
    inds.tmp <- which(model.inputs$pheno.data$train$column.key['fenotyyppi',] == feno)
    geno.inds.tmp <- apply(model.inputs$pheno.data$train$pheno.matrix[, inds.tmp, drop=F], 2, function(x){which(!is.na(x))})
    
    pheno.vect <- c()
    fixed.effects <- c()
    iter <- 1
    for (col.tmp in inds.tmp) {
      
      pheno.vect <- c(pheno.vect, model.inputs$pheno.data$train$pheno.matrix[geno.inds.tmp[[iter]], col.tmp])  
      fixed.effects <- c(fixed.effects, rep(iter, length(geno.inds.tmp[[iter]])))
      iter <- iter+1
    }
    
    geno.inds.tmp <- unname(unlist(geno.inds.tmp))
    geno.train.inds.tmp <- genotyypit[geno.inds.tmp]
    geno.inds.tmp <- c(geno.train.inds.tmp, setdiff(kaikki.genotyypit, genotyypit))
    
    
    geno.kernel.tmp <- model.inputs$extra.kernels$full.genotype.kernel[[g.ker.sel]][geno.inds.tmp, geno.inds.tmp]			
    pheno.vect <- c(pheno.vect, rep(NA, length(setdiff(kaikki.genotyypit, genotyypit))))
    # the fixed effect for all test data is assumed to be the same. Doesn't
    # affect the correlation -based results
    fixed.effects <- c(fixed.effects, rep(1, length(setdiff(kaikki.genotyypit, genotyypit))))
    
    if (!exists("method.sel")) method.sel <- 'REML'
    if (is.null(pheno.vect)) {
      
      GBLUP.preds[, feno] <- NA
      
    } else {
      
      if (length(grep(x=method, pattern='FE'))>0)  {
        
        rrBLUP.data <- data.frame(y=pheno.vect, gid=rownames(geno.kernel.tmp), env=fixed.effects)
        
      } else {
        
        rrBLUP.data <- data.frame(y=pheno.vect, gid=rownames(geno.kernel.tmp))
        
      }
      
      if (method == 'GBLUP_st_se') {
        ans <- kin.blup(data=rrBLUP.data,geno="gid",pheno="y", K=geno.kernel.tmp, reduce=T)
      } else if (method =='GBLUP_MOD' || method =='GBLUP_REML' || method =='GBLUP_ML') {
        ans <- kin.blup(data=rrBLUP.data,geno="gid",pheno="y", K=geno.kernel.tmp, reduce=T, method.sel = method.sel)
        
      } else if (method == 'GBLUP_REML_FE') {
        
        ans <- kin.blup(data=rrBLUP.data,geno="gid",pheno="y", K=geno.kernel.tmp, reduce=T, method.sel = method.sel, fixed='env')
        
      } else {
        stop('method not specified')
      }
      
      genot.inds <- unique(names(ans$g))
      learnt.params$feno <- ans
      GBLUP.preds[genot.inds, feno] <- ans$g[genot.inds]
      
      learnt.params$Kbeta <- ans$Kbeta[rownames(model.inputs$geno.kernels$train[[g.ker.sel]])]
      
    }
  }
  time.finished <- proc.time()[[3]]
  
  
  run.time <- time.finished - time.start
  
  
  learnt.params$run.time <- run.time
  learnt.params$GBLUP.preds <- GBLUP.preds

  return(learnt.params)

}

compute.GBLUP.preds <- function(learnt.params, pheno.data=model.inputs$pheno.data$train) {

	fenotyypit <- unique(pheno.data$column.key['fenotyyppi',])
	preds.train <- pheno.data$pheno.matrix
	preds.train[,] <- NA

	for (feno in fenotyypit) {
	    inds.tmp <- which(pheno.data$column.key['fenotyyppi',]==feno)
	    preds.train[rownames(pheno.data$pheno.matrix),inds.tmp] <- learnt.params$GBLUP.preds[rownames(pheno.data$pheno.matrix), feno]
	}
	return(preds.train)
}

