compute.scores <- function(preds, score.inputs, current.run=NULL, simplify=TRUE) {
  

scores.to.return <- list()



if (length(score.inputs$only.compute)==0) score.inputs$only.compute <- c('within.exp.cors', 'MSE')

  
  # total MSE
  
  if (any(score.inputs$only.compute == 'MSE')) {
    # total MSE
    scores.to.return$MSE <- mean((score.inputs$observations - preds)^2,na.rm=T)  
  }
  

    
  if (any(score.inputs$only.compute == 'within.exp.cors')) {
    

    if (any(colSums(!is.na(preds))< 3)) {
      
      if (var(c(preds), na.rm = T) < 1e-3) var.correction <-TRUE else var.correction <-  FALSE
      
    } else if (any(apply(preds,2,var,na.rm=T)<1e-5)) var.correction <- TRUE else var.correction <- FALSE
      
    if (var.correction) preds <- preds*1000
    
    
    # experiment-specific scores
    for (iter.tmp in 1:ncol(score.inputs$observations)) {


          pheno.exp.tmp <- score.inputs$observations
          pheno.exp.tmp <- pheno.exp.tmp[, iter.tmp, drop=F]
          
          preds.exp <- preds[, iter.tmp, drop=F]
          
          
          tmp.scores <- compute.var.spec.MSE(Y.test=pheno.exp.tmp, preds=preds.exp, key = score.inputs$key[, iter.tmp, drop=F])
          
          colnames.tmp <- names(tmp.scores)
          rownames.tmp <- names(tmp.scores[[1]])
          tmp.scores <- simplify2array(tmp.scores)
          tmp.scores <- matrix(tmp.scores, nrow=1)
          rownames(tmp.scores) <- rownames.tmp
          colnames(tmp.scores) <- colnames.tmp
          
          
        
        
        if (iter.tmp > 1 && exists('tmp.scores.full')) {
          tmp.scores.full <- abind(tmp.scores.full, tmp.scores,along=3)
        } else {

          tmp.scores.full <- array(tmp.scores, dim=c(dim(tmp.scores),1))
	  dimnames(tmp.scores.full)[1:2] <- dimnames(tmp.scores)
        }	
        if (sum(!is.na(score.inputs$observations[, iter.tmp ]))<=3) {

	        tmp.scores.full[,,iter.tmp] <- NA

        }
      
    }


    if (var.correction) preds <- preds/1000

    weighted.exp.cors <- named.vect.from.names(score.inputs$data.structures$all.phenotypes)
    
    
    if (length(rownames(tmp.scores.full))>1) stop('code contains parts that dont work with multiple target variables!')    

    if (exists('tmp.scores.full')) {
      for (var.tmp in rownames(tmp.scores.full)) {
        if (length(dim(tmp.scores.full))>2) {
          
          weighted.exp.cors[var.tmp] <- weighted.mean(x=tmp.scores.full[var.tmp,'var.cors',],w=tmp.scores.full[var.tmp,'n.obs.test',],na.rm=T)
          
          
        } else {

	          stop('should not happen: compute_scores_pb_single_pheno')

        }
      }
    }


    scores.to.return$within.exp.cors <- weighted.exp.cors 

    if (simplify) {
	    scores.to.return<-lapply(scores.to.return, function(x){x <- x[which(!is.na(x))]})
    }
    
    if (length(scores.to.return$within.exp.cors)==0) scores.to.return$within.exp.cors <- NA
    

    if (!is.null(current.run)) {

    	if (sum(!is.na(weighted.exp.cors))!=1) {
    	  
    	  if (sum(is.nan(weighted.exp.cors))==1) weighted.exp.cors[which(is.nan(weighted.exp.cors))]<-0 else stop('something wrong in score computations!')
    	}
    	val.tmp <- weighted.exp.cors[!is.na(weighted.exp.cors)]
    
    }
  }
  

  if (any(score.inputs$final.run)) {
  
  
    if (any(colSums(!is.na(preds))< 3)) {
      
      if (var(c(preds), na.rm = T) < 1e-3) var.correction <-TRUE else var.correction <-  FALSE
      
    } else if (any(apply(preds,2,var,na.rm=T)<1e-5)) var.correction <- TRUE else var.correction <- FALSE
    
    if (var.correction) preds <- preds*1000
    
    
    # experiment-specific scores
    
    preds.scaled <- scale(preds)
    obs.scaled <- scale(score.inputs$observations)
    
    template <- matrix(NA, nrow=(260), ncol=2)
    
    pred.output <- obs.baseline <- template
    
    pred.output[1:nrow(preds.scaled), 1:ncol(preds.scaled)] <- preds.scaled
    obs.baseline[1:nrow(obs.scaled), 1:ncol(obs.scaled)] <- obs.scaled
    
    names.tmp <-c(outer(as.character(1:260), as.character(1:2), paste, sep='_'))
    
    pred.output <- c(pred.output)
    names(pred.output) <- names.tmp
    
    obs.baseline <- c(obs.baseline)
    names(obs.baseline) <- names.tmp
    
    scores.to.return$pred.output <- pred.output
    scores.to.return$obs.baseline <- obs.baseline
    
  }
  

	
	return(scores.to.return)
	
	
}

named.vect.from.names <- function(names) {

	vect.tmp <- rep(NA, length(names))
	names(vect.tmp) <- names

	return(vect.tmp)
}


matrix.to.list <- function(matrix.input) {
  names.tmp <- outer(rownames(matrix.input), colnames(matrix.input), FUN = paste, sep='_')
  list.tmp<-list()
  for (i in 1:length(matrix.input)) {
    
    list.tmp[[names.tmp[i]]] <- matrix.input[i]
  }
  return(list.tmp)
}
