get.test.set.scores <- function(model.inputs, learnt.params, set = 'test') {
  validation.set.scores <- list()
  
  pars <- list()
  pars$ker.sel <- g.ker.sel
  pars$weight.bias <- NULL#0.00001
  Kx.valid <- process.kernels(kernels.to.normalize=model.inputs$geno.kernels[[set]], kernel.normalizers=learnt.params$kernel.normalizers.geno, pars=pars)
  
  # Environment: process the kernels into the KBMF format
  pars <- list()
  
  if (exists('e.ker.sel')) {
    pars$ker.sel <- e.ker.sel
    pars$weight.bias <- NULL
  } else pars$weight.bias <- 0
  
  
  
  Kz.valid <- process.kernels(kernels.to.normalize=model.inputs$env.kernels[[set]], kernel.normalizers=learnt.params$kernel.normalizers.env, pars=pars)
  
  if (length(grep(x=method, pattern='_1k'))>0) {
    
    Kz.valid <- Kz.valid * learnt.params$kernel.normalizer.1k
  }
  
  
  state.test <- learnt.params$state
  
  
  # set parameters for 1-way effect 
  if (length(grep(x=method, pattern='1way_g'))>0) {
    
    
    fixed.rows <- matrix(0, nrow=length(learnt.params$pheno.variables), ncol=ncol(model.inputs$pheno.data[[set]]$column.key))
    
    for (pheno.iter in 1:length(learnt.params$pheno.variables)) {
      fixed.rows[pheno.iter, which(model.inputs$pheno.data[[set]]$column.key[6,] == learnt.params$pheno.variables[pheno.iter])] <- 1
    }
    
    state.test$parameters$fixed.rows <- fixed.rows					    
  }
  
  #if (length(grep(x=method, pattern='1way_e'))>0 || length(grep(x=method, pattern='_fe'))>0) {
  if (length(grep(x=method, pattern='_fe'))>0) {
    
    
    
    fixed.cols <- matrix(1, nrow=nrow(model.inputs$pheno.data[[set]]$pheno.matrix), ncol=1)
    state.test$parameters$fixed.cols <- fixed.cols
    
  }
  
  
  preds.valid <- kbmf_regression_test(Kx = Kx.valid, Kz = Kz.valid, state=state.test)
  
  

  if (length(grep(x=method, pattern='_hst'))>0) {
    
    # case "no environment data"
    
    preds.valid <- hist.pred(preds.template=preds.valid$Y$mu, column.key=model.inputs$pheno.data[[set]]$column.key, kernel.normalizers=learnt.params$kernel.normalizers.env, state=state.test, Kx.input=Kx.valid, hist.kernels=model.inputs$historical.weather.kernels, exps.train=colnames(model.inputs$pheno.data$train$column.key), test.set.kernels=model.inputs$env.kernels[[set]])
    
  } else {
    
    preds.valid <- preds.valid$Y$mu
  }
  
  
  
  
  
  score.inputs <- list()
  score.inputs$observations <- model.inputs$pheno.data[[set]]$pheno.matrix
  score.inputs$key <- model.inputs$pheno.data[[set]]$column.key
  score.inputs$data.structures <- model.inputs$data.structures
  score.inputs$only.compute <- NULL
  
  
  
  
  # from here on everything should be standardized          
  if (set == 'valid') current.run <- model.inputs$current.exp$validation else current.run <- model.inputs$current.exp$test
  
  scores.tmp <- compute.scores(preds=preds.valid, score.inputs, current.run=current.run)
  
  
  
  # from here on everything should be standardized
  for (score in names(scores.tmp)) {
    validation.set.scores[[score]] <- scores.tmp[[score]]
  }
  
  
  return(validation.set.scores)
}