hist.pred <- function(preds.template, column.key, kernel.normalizers, state.input, Kx.input=Kx.valid, hist.kernels, exps.train, test.set.kernels) {

  hist.kernels.test <- list()

  # identify, which training rows/cols to keep:

  # generate a key for selection
  column.key.hist <- rownames(hist.kernels[[1]])
  column.key.hist <- simplify2array(strsplit(column.key.hist, split='_'))
  colnames(column.key.hist) <- rownames(hist.kernels[[1]])
  rownames(column.key.hist) <- c('vuosi', 'koeplyh', 'pheno')


  for (loc.tmp in unique(column.key['koeplyh',])) {
    
    # select cols according to 
    # 'koeplyh' and put them in hist.kernels.test
    
    # double check: make sure, that the year of the test data is not used as "history"
    hist.kernels.test[[loc.tmp]] <- lapply(hist.kernels, function(x){x[ which(column.key.hist['koeplyh', ]==loc.tmp & is.na(match(x=column.key.hist['vuosi', ], table=column.key['vuosi', ]) ) ), ]})
  }
  


  preds.template[,] <- NA
  
  for (loc.tmp in unique(column.key['koeplyh',]))
  {
    inds.tmp <- which(column.key['koeplyh', ]==loc.tmp)
    if (!is.null(hist.kernels.test[[loc.tmp]])) {

      # create a list of kernels for each year
      # -test-set specific weather observations
      # are replaced with historical values
      kernels.tmp <- catenate.for.hist.pred(historical.kernels=hist.kernels.test[[loc.tmp]], test.set.kernels=test.set.kernels)
      
      Kz.list <- list()
      
      
      # process the environment kernels into the KBMF format
      pars <- list()
      
      if (exists('e.ker.sel')) {
        pars$ker.sel <- e.ker.sel
        pars$weight.bias <- NULL
      } else pars$weight.bias <- 0
      
      for ( i in 1:length(kernels.tmp)) {
      
        Kz.list[[i]] <- process.kernels(kernels.to.normalize=kernels.tmp[[i]], kernel.normalizers=learnt.params$kernel.normalizers.env, pars=pars)
        
        # Re-normalize in case '_1k'
        if (length(grep(x=method, pattern='_1k'))>0) {
          
          Kz.list[[i]] <- Kz.list[[i]] * learnt.params$kernel.normalizer.1k
        }  
      }
      
      
      
      if (!is.null(state.input$parameters$fixed.rows)) {
        state.input$parameters$fixed.rows <- matrix(1, nrow=1, ncol=dim(Kz.list[[1]])[2])
      }
      
      preds.valid.tmp <- lapply(Kz.list, FUN=function(x){kbmf_regression_test(Kx = Kx.input, Kz = x, state=state.input)$Y$mu})
      preds.valid.tmp <- simplify2array(preds.valid.tmp)
      preds.valid.tmp <- apply(preds.valid.tmp, 1:2, median)
      
      
      preds.template[, inds.tmp] <- preds.valid.tmp
      
    }
  }
  
  return(preds.template)
}


catenate.for.hist.pred <- function(historical.kernels, test.set.kernels) {
  
  
  dim.hist <- dim(historical.kernels[[1]])
  dim.test <- dim(test.set.kernels[[1]])
  
  annual.test.kernels.list <- list()
  
  kernels.to.modify <- c("rain.lin.kernel", "rain.g.kernel", "temperature.lin.kernel", "temperature.g.kernel")
  
  for (i in 1:dim.hist[1]) {
    annual.test.kernels.list[[i]] <- test.set.kernels
    
    for (k.tmp in kernels.to.modify) {
      
      list.tmp <- list()
      for (j in 1:dim.test[1]) {
        list.tmp[[j]] <- historical.kernels[[k.tmp]][i, , drop=F]  
      }
      
      annual.test.kernels.list[[i]][[k.tmp]]  <- abind(list.tmp, along=1)
    }
    
    annual.test.kernels.list[[i]][["soil.x.rain"]] <- annual.test.kernels.list[[i]]$rain.g.kernel * annual.test.kernels.list[[i]]$soil.g.kernel
    
  }
  
  return(annual.test.kernels.list)
}