initialize.KBMF.asymmetric <- function(input) {
  
  
  parameters <- list()
  
  Dx <- dim(input$Kx)[1]
  Nx <- dim(input$Kx)[2]
  Px <- 1
  Dz <- dim(input$Kz)[1]
  Nz <- dim(input$Kz)[2]
  Pz <- dim(input$Kz)[3]
  
  
  # for multiplication of each kernel with a scalar, we need 
  # the weights
  # these must be given in the initialization
  
  if (dim(input$Kz)[3]==1) {
    
    # when fixed, use those values
    K.weights.Z <- 1
    
  } else {
  
    K.weights.Z <- input$inits$ez$mu  
  }
  
  if (file.exists(experiment$paths$A.var.path)) {
    
    
    Kz.variance.tmp <- load.var.A(PTVE.1.way.X, PTVE.1.way.Z, e.d.m, var.coef)
    Kz.variance.tmp$A.sd <- sqrt(Kz.variance.tmp$var.Az)
    
  } else {
    
    
    # Az.var.guess is the approximate variance that Az should have
    # to produce Hz variance input$PTVE.1.way.Z * input$var.env
    Az.var.guess <- naive.A.var.guess(K.tensor=input$Kz, K.weights=K.weights.Z, objective.product.var=input$PTVE.1.way.Z * input$var.env)
      
    # However, the guess turns out to be bad.
    # Get a better estimate with simulation, use the previous value
    # as an approximate center for the grid
    Kz.variance.tmp <- simulate.variance(A.var.guess=Az.var.guess, K.tensor=input$Kz, K.weights = K.weights.Z, objective.product.var = input$PTVE.1.way.Z * input$var.env)
    
  }
  
    
  parameters$var.Az.tmp <- (Kz.variance.tmp$A.sd)^2
  
  # Next the X -side
  if (dim(Kx)[3]==1) {
    
    # when fixed, use those values
    K.weights.X <- 1
    
  } else {
    
    stop('not implemented yet')
  }
  
  
  # guess similarly to Az
  # this needs not be done when only running 1_way_e:
  if (is.null(input$PTVE.1.way.X)) {
    
    print('if you want to have other than 1-way components for the genotypes, provide PTVE.1.way.X')
    
    Kx.variance.tmp <- list()
    Kx.variance.tmp$A.sd <- 0.0001
    
  } else {
    
    if (file.exists(experiment$paths$A.var.path)) {
      
      
      Kx.variance.tmp <- load.var.A(PTVE.1.way.X, PTVE.1.way.Z, e.d.m, var.coef)
      Kx.variance.tmp$A.sd <- sqrt(Kx.variance.tmp$var.Ax)
      
    } else {
    
      Ax.var.guess <- naive.A.var.guess(K.tensor=input$Kx, K.weights=K.weights.X, objective.product.var=input$PTVE.1.way.X * input$var.geno)
      
      # However, the guess turns out to be bad.
      # Get a better estimate with simulation, use the previous value
      # as an approximate center for the grid
      
      Kx.variance.tmp <- simulate.variance(A.var.guess=Ax.var.guess, K.tensor=input$Kx, K.weights = K.weights.X, objective.product.var = input$PTVE.1.way.X * input$var.geno)  
    }
    
      
  }
  
  
  
  parameters$var.Ax.tmp <- (Kx.variance.tmp$A.sd)^2
    
  
  # now assuming that 1-way effects are encoded as vectors of 1s
  parameters$alpha_lambdax_1w <- 1/(1*parameters$var.Ax.tmp^2)
  parameters$beta_lambdax_1w <- 1*parameters$var.Ax.tmp
  
  
  parameters$alpha_lambdaz_1w <- 1/(input$e1w.mod*parameters$var.Az.tmp^2)
  parameters$beta_lambdaz_1w <- input$e1w.mod*parameters$var.Az.tmp
  
   
  # 2way
  
  
  # The objectice is that 
  # the amount of variance explained by the 2-way effects is:
  # var(total 1-way) * PTVE.2.way
  #
  # now, we would get
  # input$var.geno * input$var.env * K.2way
  # where K.2way is the number f 2-way components
  #
  # if both 1-way effects are in the model, 
  # the 1-way effects explain
  # input$var.geno + input$var.env
  # 
  # compute 2-way correction coefficient:
  if (input$ftv) {
    print('take into account rank, PTVE.2.way')
    
    ind.1way.e <- as.numeric(!is.null(input$fixed.cols))
    ind.1way.g <- as.numeric(!is.null(input$fixed.rows))
    K.2way <- input$R - ind.1way.e - ind.1way.g
    # if there are no 2-way components, these coefficients 
    # will not matter. To avoid problems, perform computations
    # anyway with K.2way == 1
    if (K.2way == 0) K.2way <- 1
    
    
  } else {
    K.2way <- 1
  }
  
  
  # as a compromise, always fix 2-way variance portion to
  # 1way-g variance.
  
  #corr.coef.2way <- (ind.1way.g * input$var.geno + ind.1way.e * input$var.env) * input$PTVE.2.way / (input$var.geno * input$var.env * K.2way)
  corr.coef.2way <- input$var.geno * input$PTVE.2.way / (input$var.geno * input$var.env * K.2way)
  # both weighths for the 2-way effects are given a correction 
  # coefficient -> 1st sqrt(); var(aX) = a^2 var(X) -> 2nd sqrt()
  corr.coef.2way <- sqrt(sqrt(corr.coef.2way))
  
  
  var.Ax.2w.tmp <- parameters$var.Ax.tmp * corr.coef.2way
  var.Az.2w.tmp <- parameters$var.Az.tmp * corr.coef.2way
  
  
  
  # noise in the latent variables: specified according to 1-way
  # components
  if (is.null(input$PTVE.1.way.X)) {
    
    # this will not matter anywhere GIVEN that model is 1way_e
    parameters$sigma_hx <- 1
    
  } else {
    
    # remember to take sqrt for sd parameters!
    parameters$sigma_hx <- sqrt(input$var.geno * (1-input$PTVE.1.way.X))
  }
  parameters$sigma_hz <- sqrt(input$var.env * (1-input$PTVE.1.way.Z))
  
  
  
  parameters$alpha_lambdax_2w <- 1/(1*var.Ax.2w.tmp^2)
  parameters$beta_lambdax_2w <- 1*var.Ax.2w.tmp
  
  
  
  if (input$sparse.Az) {
    
    parameters$alpha_lambdaz_2w <- 1e-6/(1*var.Az.2w.tmp^2)
    parameters$alpha_lambdaz <- parameters$alpha_lambdaz_2w
    parameters$beta_lambdaz_2w <- 1e6*var.Az.2w.tmp
    parameters$beta_lambdaz <- parameters$beta_lambdaz_2w
    
    parameters$update.Lambda.z <- TRUE
    
  } else {
    
    parameters$alpha_lambdaz_2w <- 1/(1*var.Az.2w.tmp^2)
    parameters$beta_lambdaz_2w <- 1*var.Az.2w.tmp
    
    parameters$update.Lambda.z <- FALSE
    
  }
  
  # test the simulated variances
  Kx.Ax.var.test<- drop(input$Kx)%*% matrix(rnorm(1000*nrow(input$Kx), sd=sqrt(parameters$var.Ax.tmp)), nrow(input$Kx), 1000)
  print(mean(apply(Kx.Ax.var.test,2,var))/PTVE.1.way.X)
  
  Kz.Az.var.test<- drop(input$Kz)%*% matrix(rnorm(1000*nrow(input$Kz), sd=sqrt(parameters$var.Az.tmp)), nrow(input$Kz), 1000)
  print(mean(apply(Kz.Az.var.test,2,var))/PTVE.1.way.Z)
  
  
  
  return(parameters)
  
  
}