initialize.KBMF.asymmetric <- function(input) {
  
  
  parameters <- list()
  
  Dx <- dim(input$Kx)[1]
  Nx <- dim(input$Kx)[2]
  Px <- 1
  Dz <- dim(input$Kz)[1]
  Nz <- dim(input$Kz)[2]
  Pz <- dim(input$Kz)[3]
  
  
  # for multiplication of each kernel with a scalar, we need 
  # the weights
  if (input$fix.ez) {
    
    # when fixed, use those values
    K.weights.Z <- input$inits$ez$mu
    
  } else {
    
    # otherwise use expected kernel weights to estimate variances
    K.weights.Z <- rep((input$alpha_eta * input$beta_eta), Pz)
  }
  
  
  # Az.var.guess is the approximate variance that Az should have
  # to produce Hz variance input$PTVE.1.way.Z * input$var.env
  Az.var.guess <- naive.A.var.guess(K.tensor=input$Kz, K.weights=K.weights.Z, objective.product.var=input$PTVE.1.way.Z * input$var.env)
    
  # However, the guess turns out to be bad.
  # Get a better estimate with simulation, use the previous value
  # as an approximate center for the grid
  Kz.variance.tmp <- simulate.variance(A.var.guess=Az.var.guess, K.tensor=input$Kz, K.weights = K.weights.Z, objective.product.var = input$PTVE.1.way.Z * input$var.env)
  
  print('study!')
  browser()
    
  parameters$var.Az.tmp <- (Kz.variance.tmp$A.sd)^2
  
  # Next the X -side
  if (dim(Kx)[3]==1) {
    
    # when fixed, use those values
    K.weights.X <- 1
    
  } else {
    
    stop('not implemented yet')
  }
  
  
  # guess similarly to Az
  # this needs not be done when only running 1_way_e:
  if (is.null(input$PTVE.1.way.X)) {
    
    print('if you want to have other than 1-way components for the genotypes, provide PTVE.1.way.X')
    
    Kx.variance.tmp <- list()
    Kx.variance.tmp$A.sd <- 0.0001
    
  } else {
    
    Ax.var.guess <- naive.A.var.guess(K.tensor=input$Kx, K.weights=K.weights.X, objective.product.var=input$PTVE.1.way.X * input$var.geno)
    
    # However, the guess turns out to be bad.
    # Get a better estimate with simulation, use the previous value
    # as an approximate center for the grid
    
    Kx.variance.tmp <- simulate.variance(A.var.guess=Ax.var.guess, K.tensor=input$Kx, K.weights = K.weights.X, objective.product.var = input$PTVE.1.way.X * input$var.geno)  
  }
  
  
  parameters$var.Ax.tmp <- (Kx.variance.tmp$A.sd)^2
    
  
  # now assuming that 1-way effects are encoded as vectors of 1s
  parameters$alpha_lambdax_1w <- 1/(1*parameters$var.Ax.tmp^2)
  parameters$beta_lambdax_1w <- 1*parameters$var.Ax.tmp
  
  parameters$alpha_lambdaz_1w <- 1/(1*parameters$var.Az.tmp^2)
  parameters$beta_lambdaz_1w <- 1*parameters$var.Az.tmp
  
   
  # 2way
  
  
  # The amount of variance explained by the 2-way effects:
  # var(total 1-way) * PTVE.2.way
  # now, we would get
  # input$var.geno * input$var.env
  # whereas 1-way effects explain
  # input$var.geno + input$var.env
  #
  # compute 2-way correction coefficient:
  corr.coef.2way <- (input$var.geno + input$var.env)*input$PTVE.2.way / (input$var.geno * input$var.env)
  # both weighths for the 2-way effects are given a correction 
  # coefficient -> 1st sqrt(); var(aX) = a^2 var(X) -> 2nd sqrt()
  corr.coef.2way <- sqrt(sqrt(corr.coef.2way))
  
  
  var.Ax.2w.tmp <- parameters$var.Ax.tmp * corr.coef.2way
  var.Az.2w.tmp <- parameters$var.Az.tmp * corr.coef.2way
  
  
  
  # noise in the latent variables: specified according to 1-way
  # components
  if (is.null(input$PTVE.1.way.X)) {
    
    # this will not matter anywhere GIVEN that model is 1way_e
    parameters$sigma_hx <- 1
    
  } else {
    parameters$sigma_hx <- input$var.geno * (1-input$PTVE.1.way.X)
  }
  parameters$sigma_hz <- input$var.env * (1-input$PTVE.1.way.Z)
  
  
  
  parameters$alpha_lambdax_2w <- 1/(1*var.Ax.2w.tmp^2)
  parameters$beta_lambdax_2w <- 1*var.Ax.2w.tmp
  
  parameters$alpha_lambdaz_2w <- 1/(1*var.Az.2w.tmp^2)
  parameters$beta_lambdaz_2w <- 1*var.Az.2w.tmp
  
  
  return(parameters)
  
  
}