set.parameters <- function(method, seed, pheno.matr, learnt.params, filenames.list, column.key) {
  
  varargin = list()
  
  if (exists('n.iter', where=globalenv())) varargin$iteration <- n.iter
  if (exists('alpha.eta', where=globalenv())) varargin$alpha_eta <- alpha.eta
  if (exists('beta.eta', where=globalenv())) varargin$beta_eta <- beta.eta
  if (exists('sigma.g', where=globalenv())) varargin$sigma_g <- sigma.g else varargin$sigma_g <- 1
  if (exists('sigma.h', where=globalenv())) varargin$sigma_h <- sigma.h else varargin$sigma_h <- 1
  if (exists('sigma.hz', where=globalenv())) varargin$sigma_hz <- sigma.hz else varargin$sigma_hz <- 1
  #if (exists('sigma.gx', where=globalenv())) varargin$sigma_gx <- sigma.gx else varargin$sigma_gx <- 1
  #if (exists('sigma.gz', where=globalenv())) varargin$sigma_gz <- sigma.gz else varargin$sigma_gz <- 1
  if (exists('sigma.y', where=globalenv())) varargin$sigma_y <- sigma.y
  if (exists('sigma.shrink', where=globalenv())) varargin$sigma.shrink <- sigma.shrink
  if (exists('PTVE.1.way.Z', where=globalenv())) varargin$PTVE.1.way.Z <- PTVE.1.way.Z
  if (exists('PTVE.1.way.X', where=globalenv())) varargin$PTVE.1.way.X <- PTVE.1.way.X
  if (exists('PTVE.2.way', where=globalenv())) varargin$PTVE.2.way <- PTVE.2.way else varargin$PTVE.2.way <- 1
  if (exists('fix.ex', where=globalenv())) varargin$fix.ex <- fix.ex else varargin$fix.ex <- TRUE
  
  #

# kernel weight sparsity  
#	varargin$alpha_eta <- 1e-3
#	varargin$beta_eta <- 1e3

  

	if (length(grep(x=method, pattern='_lkw'))>0 || method == 'KBMF_1way_e') varargin$fix.ez <- FALSE else if (exists('fix.ez', where=globalenv())) varargin$fix.ez <- fix.ez else stop('not specified')



  
  
  if (exists('init.mode', where=globalenv())) varargin$init.mode <- init.mode else varargin$init.mode <- 2
  
  if (exists('e1w.mod', where=globalenv())) varargin$e1w.mod <- e1w.mod else varargin$e1w.mod <- 1
  
  # early stopping for the 
  if (length(grep(x=method, pattern='_es'))>0) {
    varargin$es <- TRUE
  } else varargin$es <- FALSE
  
  if (length(grep(x=method, pattern='KBMF2'))>0) {
    varargin$shared.sigma.y <- TRUE
  } else varargin$shared.sigma.y <- FALSE
  
  
  varargin$seed <- seed
  
  
  
  
  ####################################
  # to use prelearnt kernel weights: #
  ####################################
  #
  if (varargin$fix.ez && method != 'KBMF_1way_g') {
    
    load.path <- experiment$current.run$filenames.list$model.filename
    load.path <- gsub(load.path, pattern = method, replacement = 'KBMF_1way_e')
    load.path <- gsub(load.path, pattern = paste0('_K_', K), replacement = paste0('_K_', 1))
    load.path <- gsub(load.path, pattern = paste0('_PTVE.1.way.X_', PTVE.1.way.X), replacement = '')
    load.path <- strsplit(load.path, split='_var.coef_')[[1]][1]
    load.path <- paste0(load.path, '_PTVE.1.way.Z_', PTVE.1.way.Z, '_fix.ez_FALSE_var.coef_', var.coef, '_n.iter_200_validation.fold_', validation.fold, '.RData')
    load(load.path)
    
    
    #stop('not implemented yet')
    #ez.weight.path <- paste0(experiment$paths$arch.root, '/e_pb11/collectors/collector_KBMF_1way_e_1.RData')
    #load(ez.weight.path)
    tmp.ez <- learnt.params$state$ez$mu
    names(tmp.ez) <- c("ez=env.kernel", "ez=soil.g.kernel", "ez=soil.lin.kernel", "ez=soil.org.g.kernel", "ez=temperature.lin.kernel", "ez=temperature.g.kernel", "ez=rain.lin.kernel", "ez=rain.g.kernel", "ez=soil.x.rain", "ez=")
    
    tmp.ez <- tmp.ez/sqrt(sum(tmp.ez^2))
    
    # ez.normalized <- apply(drop(param.scores.tables$KBMF_1way_e$ez), 1:4, function(x){
    #   max.element <- which.max(abs(x))[1];
    #   max.element <- x[max.element];
    #   to.return <- x/max.element;
    #   return(to.return)})
    # 
    
    
    
    # have a look at the things to select from...
    #normed.ez.means <- apply(ez.normalized, c(1,3), mean, na.rm=T)
    #tmp.ez.val <- 1/sqrt(sum(tmp.ez^2))
    
    
    #varargin$inits$ez$mu <- varargin$inits$ez$mu / max(varargin$inits$ez$mu)
    
    varargin$inits$ez$mu <- tmp.ez
    
    if (length(grep(x=method, pattern='_2ez'))>0) {
      # use the kernel weights learnt by _lkw -model
      
      norm.current <- sqrt(sum(ez.vals.from.1way.g.2way^2))
      
      norm.objective.tmp <- sqrt(sum(varargin$inits$ez$mu^2))
      if (sum(abs(norm.current-norm.objective.tmp))<1e-6) {
        print('no normalization needed')
      } else stop('normalization not done yet!')
      varargin$inits$ez$mu[1:length(varargin$inits$ez$mu)] <- ez.vals.from.1way.g.2way  
    }
    
  } else {
    
    names.tmp <-c("ez=env.kernel", "ez=soil.g.kernel", "ez=soil.lin.kernel", "ez=soil.org.g.kernel", "ez=temperature.lin.kernel", "ez=temperature.g.kernel", "ez=rain.lin.kernel", "ez=rain.g.kernel", "ez=soil.x.rain", "ez=")
    
    tmp.ez <- rep(1, length(names.tmp))
    names(tmp.ez) <- names.tmp
    tmp.ez[length(tmp.ez)] <- 1e-6
    
    #tmp.ez <- normed.ez.means[, paste0('pheno=', pheno)]
    #tmp.ez <- tmp.ez/max(tmp.ez)
    
    tmp.ez.val <- 1/sqrt(sum(tmp.ez^2))
    tmp.ez[1:(length(tmp.ez)-1)] <- tmp.ez.val
    
    
    varargin$inits$ez$mu <- tmp.ez
  }
  
  if (!exists('g.var.coef', where=globalenv())) g.var.coef <- 1
  if (!exists('var.coef', where=globalenv())) var.coef <- 1


  # genetic variance
  if (exists('g.var', where=globalenv())) {


	Y.matr.var <- var(c(pheno.matr), na.rm=T)
	sigma2.y.obj <- y.var * Y.matr.var
	varargin$tau_beta <- 1e1
	varargin$tau_alpha <- (1/sigma2.y.obj) * varargin$tau_beta


	varargin$var.geno <- g.var * Y.matr.var
	varargin$var.env <- 1/K * (1-y.var) * Y.matr.var

  } else {

	# normalize variance by rank
	var.coef <- var.coef/K

#	varargin$var.geno <- g.var.coef*var.coef*weighted.mean(x=apply(pheno.matr,2,var, na.rm=T), w = colSums(!is.na(pheno.matr)))
	varargin$var.geno <- 1 * var.coef * (1-e.var)
	# environmental variance
#  	varargin$var.env <- var.coef*weighted.mean(x=apply(pheno.matr,1,var, na.rm=T), w = rowSums(!is.na(pheno.matr)), na.rm=T)
  	varargin$var.env <- 1 * var.coef * (e.var)

	print('kaytetiin uutta')

  }
  
  
  # using REML estimates as initializations for 1-way effects
  
  varargin$init.paths <- list()
  path.tmp <- filenames.list$model.filename
  
  path.tmp <- strsplit(path.tmp, split=method)
  
  path.tmp2 <- paste0('learnt_params',filenames.list$data.info.str)
  path.tmp2 <- sub(path.tmp2, pattern='_e.d.m_', replacement = '_g.ker.sel_1_e.d.m_')
  
  if (length(grep(x=filenames.list$model.filename, pattern='final'))>0) {
    path.tmp2 <- paste0('final_', path.tmp2)
  }
  
  path.tmp <- paste0(path.tmp[[1]][1], 'GBLUP_REML_FE/', path.tmp2, '_method_GBLUP_REML_FE_method.sel_REML')

#  path.tmp <- paste0(path.tmp[[1]][1], 'GBLUP_REML_FE')#, , 'GBLUP_REML_FE_method.sel_REML')

  if (!exists('validation.fold', where=globalenv())) to.add <- '.RData' else {
  	to.add <- paste0('_validation.fold_', validation.fold, '.RData')
  } 

  path.tmp <- paste0(path.tmp, to.add)
  
  
  varargin$init.paths$one_way_g <- path.tmp
  varargin$init.rownames <- dimnames(model.inputs$geno.kernels$train[[1]])[1]
  
  
  
  # set parameters for 1-way effect 
  if (length(grep(x=method, pattern='1way_g'))>0) {
    
    
    
    fixed.rows <- matrix(0, nrow=length(learnt.params$pheno.variables), ncol=ncol(column.key))
    
    for (pheno.iter in 1:length(learnt.params$pheno.variables)) {
      
      fixed.rows[pheno.iter, which(column.key[6,] == learnt.params$pheno.variables[pheno.iter])] <- 1
    }
    
    varargin$fixed.rows <- fixed.rows
    
    
  }
  if (length(grep(x=method, pattern='1way_e'))>0) {
    
    fixed.cols <- matrix(1, nrow=nrow(pheno.matr), ncol=1)
    varargin$fixed.cols <- fixed.cols
  }
  
  return(varargin)
}
