# see
# /m/cs/scratch/fidipro_hm/EXPERIMENTS/e_pb17/A_variance_grid.R
# for how the file was created

load.var.A <- function(PTVE.1.way.X, PTVE.1.way.Z, e.d.m, var.coef) {
  
  if (!any(setup== c(1,2)) || g.ds.f !=1 || e.ds.f !=1 || gauss.par != 1 || pheno != 'sato' || g.ker.sel != 1) stop('not done yet')
  
  load(experiment$paths$A.var.path)
  to.return <- list()
  
  if (any(var.coef == c(0.05, 0.15, 0.45, 1.35)) && PTVE.1.way.X == c(0.95) && any(PTVE.1.way.Z == c(0.1, 0.5))) {
    
    # case: the exact simulation has been run, use the variance from there
    to.return$var.Ax <- Ax.variances[,,,,,,paste0('e.d.m=', e.d.m), 'method=KBMF_1way_g_2way_fe_1k' , paste0('var.coef=', var.coef), paste0('PTVE.1.way.Z=', PTVE.1.way.Z), paste0('PTVE.1.way.X=', PTVE.1.way.X),,,,,]
    to.return$var.Az <- Az.variances[,,,,,,paste0('e.d.m=', e.d.m), 'method=KBMF_1way_g_2way_fe_1k' , paste0('var.coef=', var.coef), paste0('PTVE.1.way.Z=', PTVE.1.way.Z), paste0('PTVE.1.way.X=', PTVE.1.way.X),,,,,]  
    
  } else {
    # extrapolate:
    # PTVE, var coef are independent.
    y <- c(rowMeans(drop(Ax.variances)))
    x <- 0.95 * c(0.05,0.15,0.45,1.35)
    Ax.variance.095.fun <- lm(y ~ x - 1)
    
    to.return$var.Ax <- Ax.variance.095.fun$coefficients * PTVE.1.way.X * var.coef
    
    y <- c(drop(Az.variances))
    x <- c(outer(c(0.05,0.15,0.45,1.35), c(0.1, 0.5)))
    
    Az.variance.095.fun <- lm(y ~ x - 1)
    
    to.return$var.Az <- Az.variance.095.fun$coefficients * PTVE.1.way.Z * var.coef
    
  }
  
  
  return(to.return)
}

