naive.A.var.guess <- function(K.tensor, K.weights, objective.product.var) {
  
  Dz <- dim(K.tensor)[1]
  
  # "average variance of the features in each kernel"
  # -need to take into account Dz after this!
  mean.var.Kz <- apply(apply(K.tensor, c(2,3), var),2,mean)
  
  
  mean.var.Kz <- mean.var.Kz * K.weights^2
  
  # "summation over kernels", some variance comes from each kernel
  # -note the averaged feature variances used still
  mean.var.Kz <- sum(mean.var.Kz)
  
  
  # also the mean of Kz contributes
  Kz.means <- sum(apply(K.tensor, 3, mean) * abs(K.weights))
  
  
  # the approximate variance that Az should have
  var.Az.tmp <- objective.product.var  / (Dz * mean.var.Kz + Dz * Kz.means)
 
  return(var.Az.tmp)
  
  
}