simulate.variance <- function(A.var.guess, K.tensor, K.weights, n.scale.vals = 300, n.reps=5, objective.product.var) {
  
  
  
  
  parameters <- list()
  
  Pz <- dim(K.tensor)[3]
  Dz <- dim(K.tensor)[1]
  
  # correction scaling
  scales.tmp <- exp(seq(from=log(0.001),to=log(50), length.out=n.scale.vals))
  scales.tmp <- sqrt(scales.tmp)
  
  vars.tmp <- array(NA, dim=c(Pz, n.reps, n.scale.vals))
  
  for (scale.tmp in 1:n.scale.vals) {
    
    for (iter.tmp in 1:n.reps) {
      
      weights.tmp <- matrix(rnorm(Dz, sd=scales.tmp[scale.tmp]*sqrt(A.var.guess)), nrow=Dz, ncol=1) 
      
      for (k.iter.tmp in 1:Pz) {
        
        vars.tmp[k.iter.tmp, iter.tmp, scale.tmp]  <- var(c(K.weights[k.iter.tmp] * K.tensor[,,k.iter.tmp]%*% weights.tmp))
      }   
    }  
  }
  
  # fit a polynomial regression to smooth away random variation
  medians.tmp <- apply(apply(vars.tmp, c(2,3), sum), 2, quantile, prob=0.5)
  fit.tmp <- lm(medians.tmp ~ 0 + scales.tmp + I(scales.tmp^2))
  
  fitted.variance <- fit.tmp$coefficients[1]*scales.tmp + fit.tmp$coefficients[2]*(scales.tmp^2)
  
  
  
  # plot(x=scales.tmp, y=medians.tmp)
  #lines(x=scales.tmp, y=fitted.variance)
  correction.scale <- scales.tmp[which.min(abs(fitted.variance-objective.product.var))]
  
  
  print(paste(which.min(abs(fitted.variance-objective.product.var)), 300))
  
  parameters$A.sd <- sqrt(A.var.guess) * correction.scale
  print(paste(parameters$A.sd^2,1/(parameters$A.sd)^2))
  
  
  # final check
  n.reps <- 100
  vars.tmp <- array(NA, dim=c(Pz, n.reps))


  for (iter.tmp in 1:n.reps) {

    weights.tmp <- matrix(rnorm(Dz, sd=parameters$A.sd), nrow=Dz, ncol=1)

    for (k.iter.tmp in 1:Pz) {

      vars.tmp[k.iter.tmp, iter.tmp]  <- var(c(K.weights[k.iter.tmp] * K.tensor[,,k.iter.tmp]%*% weights.tmp))
    }
  }

  
  print(paste('should be', objective.product.var, 'and is', median(colSums(vars.tmp))))
  
  
  # ok
  
  parameters$test.res <- median(colSums(vars.tmp))
  
  return(parameters)
}