process.kernels <- function(kernels.to.normalize, kernel.normalizers, pars=list()) {
  
  # normalize kernels to give a priori
  # the same variance for the predictions
  for (ker.tmp in names(kernel.normalizers)) {
    kernels.to.normalize[[ker.tmp]] <- kernels.to.normalize[[ker.tmp]] * kernel.normalizers[ker.tmp]
  }
  
  K.array <- catenate.KBMF.kernels(kernels.to.normalize)
  K.array <- aperm(K.array, perm=c(2,1,3))
  
  
  
  # select a kernel
  if (!is.null(pars$ker.sel)) {
    
    K.array <- K.array[,,pars$ker.sel, drop=F]
  }
  
  
  
  if (!is.null(pars$weight.bias)) {
    
    if (pars$weight.bias==0) {
      
      # case: test/validation set
      # add insignificant kernel to get rid of last kernel weight -bias
      K.array <- abind(K.array, matrix(0, nrow=nrow(K.array), ncol=ncol(K.array)), along=3)  
      
    } else {
      
      # case: training set
      # add insignificant diagonal kernel to get rid of last kernel weight -bias
      
      K.array <- abind(K.array, pars$weight.bias * diag(nrow(K.array)), along=3)  
    }
    
  }
  
  
  # sum all Z kernels into a single kernel
  
  if (length(grep(x=method, pattern='_1k'))>0 && dim(K.array)[3] > 1) {
    
    load.path <- experiment$current.run$filenames.list$model.filename

    if (length(grep(load.path, pattern='validation.fold_NA'))>0) {
	load.path <- gsub(load.path, pattern = '_validation.fold_NA', replacement = '')
	add.final <- TRUE
    } else add.final <- FALSE

    load.path <- strsplit(load.path, split=method)[[1]][1:3]

	    
    if (exists('validation.fold', where=globalenv())) {
      
       #load.path[3] <- paste0('_par.comb_2_var.A_0.1_bias_0_n.iter_1000_validation.fold_', validation.fold, '.RData')


	load.path[[3]] <- '.RData'
       load.path <- paste(load.path, collapse= 'BEMKL_weights')
    
#       load.path <- gsub(load.path, pattern = 'learnt_params', replacement = 'param_scores')
       
#       if (e.d.m != 1) {
         
#         load.path <- gsub(load.path, pattern = paste0('e_d.m_', e.d.m), replacement = paste0('e_d.m_', 1))
         
       
#       }
       
       if (length(grep(load.path, pattern='validation.fold_NA'))>0) {
         
         load.path <- gsub(load.path, pattern = '_validation.fold_NA', replacement = '')
         
         load.path <- gsub(load.path, pattern = 'param_scores', replacement = 'final_param_scores')
       }
       
    
       if (file.exists(load.path)) {
         load(load.path)
       }

    } else {

       load.path[3] <- paste0('_par.comb_2_var.A_0.1_bias_0_n.iter_1000.RData')


       load.path <- paste(load.path, collapse= 'KBMF_weights')
       if (add.final) {
	   load.path <- gsub(load.path, pattern = 'learnt_params', replacement = 'final_param_scores')
       } else {
	   load.path <- gsub(load.path, pattern = 'learnt_params', replacement = 'param_scores')
       }


    
       if (file.exists(load.path)) {
         load(load.path)
       } else stop('problem in kernel weight files')

    }
    
    #load("/m/cs/scratch/fidipro_hm/EXPERIMENTS/e_pb17/runs/pheno_sato/setup_2/test_fold_1/e_ds.f_1/g_ds.f_1/e_d.m_1/gauss_par_1/g_ker.sel_1/KBMF_weights/param_scores_setup_1_test.fold_1_g.ds.f_1_e.ds.f_1_gauss.par_1_pheno_sato_g.ker.sel_1_e.d.m_1_method_KBMF_weights_par.comb_2_var.A_0.1_bias_0_n.iter_1000_validation.fold_1.RData")
    

    # load and process ez
    tmp.ez <- BEMKL.weights$ez
    names(tmp.ez) <- c("ez=env.kernel", "ez=soil.g.kernel", "ez=soil.lin.kernel", "ez=soil.org.g.kernel", "ez=temperature.lin.kernel", "ez=temperature.g.kernel", "ez=rain.lin.kernel", "ez=rain.g.kernel", "ez=soil.x.rain", "ez=")
    
    # normalize so that the maximal (in absolute value) element is >0
    tmp.ez <- tmp.ez/tmp.ez[which.max(abs(tmp.ez))]
    # normalize
    tmp.ez <- tmp.ez/sqrt(sum(tmp.ez^2))
    
    
    # sum all Z kernels into a single kernel
    K.array <- apply(K.array, c(1,2), function(x){sum(x*tmp.ez)})
    K.array <- array(K.array, dim=c(dim(K.array),1))
      

    
    
  }
  
  
  
  return(K.array)
}
