source.code <- function(experiment) {
  
  library('softImpute')
  library('moments')
  library(abind)
  
  
  
  source(paste(experiment$paths$base.codes.path,'/compute_validation_scores.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/process_kernels.R', sep=''))
  
  
  source(paste(experiment$paths$base.codes.path,'/var_spec_MSE.R', sep=''))
  source(paste(experiment$paths$base.codes.path,'/compute_scores_pb_single_pheno2.R', sep=''))
  
  
  
  source(paste(experiment$paths$base.codes.path,'/initialization/KBMF_init_asymmetric3.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/initialization/simulate_variance.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/initialization/naive_A_var_guess.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/initialization/initialize_H2.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/initialization/set_parameters2.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/initialization/set_parameters_learn_weights.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/initialization/load_var_A.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/process_kernels.R', sep=''))
  
  source(paste(experiment$paths$base.codes.path,'/hist_pred.R', sep=''))
  
  # GBLUP
  library('rrBLUP')
  source(paste0(experiment$paths$GBLUP_MOD, '/kin_blup_MOD.R'))
  source(paste0(experiment$paths$GBLUP_MOD, '/mixed_solve_MOD.R'))
  source(paste0(experiment$paths$GBLUP_MOD, '/learn_GBLUP_pars.R'))
  
  # KBMF
  wd.old <- getwd()
  setwd(experiment$paths$kbmf)		
  source("kbmf_regression_train.R")
  source("kbmf_regression_test.R")		
  
  source_directory("kbmf1k1k")
  # source_directory("kbmf1k1mkl")
  # source_directory("kbmf1mkl1k")
  # source_directory("kbmf1mkl1mkl")
  # 
  setwd(wd.old)
  
  # BEMKL
  setwd(experiment$paths$learn_weights)		
  source("bemkl_supervised_regression_variational_train.R")
  source("bemkl_supervised_regression_variational_test.R")	
  setwd(wd.old)
  
  source(paste0(experiment$paths$kbmf, '/catenate_KBMF_kernels.R'))
}
