compute.var.spec.MSE <- function(Y.test, preds, key) {
	
	if (is.null(preds)) {
		
		preds <- Y.test
		preds[!is.na(preds)] <- 0
		zero.cor <- TRUE
	} else {
		zero.cor <- FALSE
	}
	
	
	to.return.MSE <- rep(NA,length(unique(key['fenotyyppi',])))
	to.return.sd <- rep(NA,length(unique(key['fenotyyppi',])))
	to.return.cor <- rep(NA,length(unique(key['fenotyyppi',])))
	to.return.n.obs.test <- rep(NA,length(unique(key['fenotyyppi',])))	

	names(to.return.MSE) <- unique(key['fenotyyppi',])
	names(to.return.sd) <- unique(key['fenotyyppi',])
	names(to.return.cor) <- unique(key['fenotyyppi',])
	names(to.return.n.obs.test)  <- unique(key['fenotyyppi',])

	for (var.tmp in unique(key['fenotyyppi',])) {
		
		# get cols corresponding to var.tmp
		inds.to.var <- which(key['fenotyyppi',]==var.tmp)
		
		# scale with total mean and total variance (no col-specific)
		resids.tmp <- (Y.test[,inds.to.var]-preds[,inds.to.var])^2

		# number of observations in test set
		to.return.n.obs.test[var.tmp] <- sum(!is.na(Y.test[,inds.to.var]))
		
		# means
		to.return.MSE[var.tmp] <- mean(resids.tmp, na.rm=T)
		
		# sd
		to.return.sd[var.tmp] <- sd(resids.tmp, na.rm=T)
		
		Y.available.inds <- which(!is.na(Y.test[,inds.to.var]))
		X.available <- preds[,inds.to.var]
		X.available <- X.available[Y.available.inds]
		
		# correlations
		if (zero.cor) {
			cor.tmp <- 0
		} else {
			if (is.na(sd(Y.test[,inds.to.var], na.rm=T)) || sd(Y.test[,inds.to.var],na.rm=T) < 1e-6 || sd(X.available) < 1e-6 ) {
				cor.tmp <- NA
			} else {
				cor.tmp <- cor(as.numeric(Y.test[,inds.to.var]), as.numeric(preds[,inds.to.var]), use="pairwise.complete.obs")	
			}
		}
		
		to.return.cor[var.tmp] <- cor.tmp
		
		
	}
	
	
	return(list(var.MSEs = to.return.MSE, var.sdSE = to.return.sd, var.cors=to.return.cor, n.obs.test=to.return.n.obs.test))
	
}
