# Mehmet Gonen (mehmet.gonen@gmail.com)

kbmf1k1k_semisupervised_regression_variational_test <- function(Kx, Kz, state, only1way) {
  Nx <- dim(Kx)[2]
  Nz <- dim(Kz)[2]
  
  
  
  Pz <- dim(Kz)[3]
  Rx.eff <- ncol(state$Ax$mu)
  Rz.eff <- ncol(state$Az$mu)
  if (is.null(Rz.eff)) Rz.eff <- 0
  
  
  
  if (!is.null(state$parameters$fixed.cols)) Rx.fixed <- ncol(state$parameters$fixed.cols) else Rx.fixed <- 0
  
  
  if (!is.null(state$parameters$fixed.rows)) Rz.fixed <- nrow(state$parameters$fixed.rows) else Rz.fixed <- 0
  
  
  R <- state$parameters$R
  
  Hx <- list(mu = matrix(0, Rx.eff, Nx))
  Hx$mu <- crossprod(state$Ax$mu, Kx)
  
  
  # 1-way effect components: x
  Hx.mu.tmp <-  matrix(NA, nrow=(nrow(Hx$mu) + Rx.fixed), ncol= ncol(Hx$mu))
  if (nrow(Hx$mu) > 0) {
    Hx.mu.tmp[state$parameters$R.eff.inds.X,] <- Hx$mu  
  }
  if (Rx.fixed>0) {
    Hx.mu.tmp[setdiff(1:nrow(Hx.mu.tmp), state$parameters$R.eff.inds.X), ] <- t(state$parameters$fixed.cols)
  }
  Hx$mu <- Hx.mu.tmp
  
  Hz <- list(mu = matrix(0, Rz.eff, Nz))
  if (Rz.eff>0) Hz$mu <- crossprod(state$Az$mu, Kz) 
  
  
  # 1-way effect components: z
  Hz.mu.tmp <-  matrix(NA, nrow=(nrow(Hz$mu) + Rz.fixed), ncol= ncol(Hz$mu))
  if (nrow(Hz$mu) > 0) {
    Hz.mu.tmp[state$parameters$R.eff.inds.Z,] <- Hz$mu  
  }
  if (Rz.fixed>0) {
    if (nrow(Hz.mu.tmp)>Rz.fixed) {
      Hz.mu.tmp[setdiff(1:nrow(Hz.mu.tmp), state$parameters$R.eff.inds.Z), ] <- t(state$parameters$fixed.rows)  
    } else if (Rz.fixed == nrow(Hz.mu.tmp)) {
      
      Hz.mu.tmp[1:nrow(Hz.mu.tmp), ] <- t(state$parameters$fixed.rows)  
    } else {
      stop('this is new: in predict function')
    }
    
  }
  Hz$mu <- Hz.mu.tmp
  
  if (only1way) {
    # make predictions only with the 1-way component
    #if (!is.null(state$parameters$fixed.cols)) stop('check that things work with 1-way Z -components')
    
    components.to.use <- sort(c(setdiff(1:nrow(Hz.mu.tmp), state$parameters$R.eff.inds.Z), setdiff(1:nrow(Hx.mu.tmp), state$parameters$R.eff.inds.X)))
    
    Y <- list(mu = crossprod(Hx$mu[components.to.use, , drop=F], Hz$mu[components.to.use, , drop=F]))
  } else {
    Y <- list(mu = crossprod(Hx$mu, Hz$mu))  
  }
  
  
  
  prediction <- list(Hx = Hx, Hz = Hz, Y = Y)
}