# Mehmet Gonen (mehmet.gonen@gmail.com)

source_directory <- function(path) {
  files <- sort(dir(path, "\\.[rR]$", full.names = TRUE))
  lapply(files, source, chdir = TRUE)
}

kbmf_regression_train <- function(Kx, Kz, Y, R, varargin) {
  
  
  Px <- dim(Kx)[3]
  Pz <- dim(Kz)[3]
  is_supervised <- all(!is.na(Y))

  # defaults
  parameters <- list()
  parameters$alpha_lambda <- 1
  parameters$beta_lambda <- 1
  
  parameters$alpha_eta <- 1
  parameters$beta_eta <- 1
  
  parameters$iteration <- 200
  parameters$progress <- 1
  parameters$R <- R
  
  
  
  parameters$PTVE.2.way <- 1
  parameters$tau_alpha <- 1
  parameters$tau_beta <- 1
  parameters$sigma_gz <- 0.1 
  
  parameters$sigma.H.1way <-  10^(-10)
  
  
  train_function <- kbmf1k1k_semisupervised_regression_variational_train
  test_function <- kbmf1k1k_semisupervised_regression_variational_test  
  

  if (missing(varargin) == FALSE) {
    for (name in names(varargin)) {
      parameters[[name]] <- varargin[[name]]
    } 
  }

  parameters$train_function <- train_function
  parameters$test_function <- test_function
  
  # initialization: weight parameter variances
  initialization.inputs <- list()
  initialization.inputs$Kx <- Kx
  initialization.inputs$Kz <- Kz
  
  
  #initialization.inputs$init.paths$one_way_g <- varargin$init.paths$one_way_g  
  initialization.inputs$var.geno <- varargin$var.geno
  
  
  initialization.inputs$alpha_eta <- varargin$alpha_eta  
  initialization.inputs$beta_eta <- varargin$beta_eta
  
  initialization.inputs$PTVE.1.way.Z <- varargin$PTVE.1.way.Z
  initialization.inputs$var.env <- varargin$var.env
  initialization.inputs$var.geno <- varargin$var.geno
  initialization.inputs$PTVE.2.way <- varargin$PTVE.2.way
  initialization.inputs$PTVE.1.way.X <- varargin$PTVE.1.way.X
  initialization.inputs$inits$ez$mu <- varargin$inits$ez$mu
  if (is.null(varargin$e1w.mod)) initialization.inputs$e1w.mod <- 1 else initialization.inputs$e1w.mod <- varargin$e1w.mod
  initialization.inputs$fixed.rows <- varargin$fixed.rows
  initialization.inputs$fixed.cols <- varargin$fixed.cols
  initialization.inputs$R <- R
  initialization.inputs$sparse.Az <- varargin$sparse.Az
  initialization.inputs$ftv <- varargin$ftv
  
  
  
  # compute variances of weight parameters that result
  # in observed variances
  variance.inits <- initialize.KBMF.asymmetric(initialization.inputs)
  
  # initialization: latent components
  inputs <- list()
  inputs$init.mode <- varargin$init.mode
  inputs$var.env <- varargin$var.env
  inputs$var.geno <- varargin$var.geno
  inputs$PTVE.2.way <- varargin$PTVE.2.way
  
  inputs$Y <- Y
  inputs$fixed.rows <- varargin$fixed.rows
  inputs$fixed.cols <- varargin$fixed.cols
  inputs$init.rownames[[1]] <- varargin$init.rownames[[1]]
  inputs$init.paths <- list()
  inputs$init.paths$one_way_g <- varargin$init.paths$one_way_g
  
  R.fixed <- 0
  if (!is.null(varargin$fixed.rows)) R.fixed <- R.fixed + nrow(varargin$fixed.rows)
  if (!is.null(varargin$fixed.cols)) R.fixed <- R.fixed + ncol(varargin$fixed.cols)
  if (R < R.fixed) stop('not enough components for fixed effects') else {
    inputs$K.2way <- R-R.fixed
  }
  
  # initialize 2-way components using svd and 1-way (genotype)
  # components using GBLUP models
  H.inits <- initialize.H(inputs)
  
  
  # give the initializations to the learning function
  for (var.tmp in names(variance.inits)) {
    parameters[[var.tmp]] <- variance.inits[[var.tmp]]
  }
  for (var.tmp in names(H.inits)) {
    parameters[[var.tmp]] <- H.inits[[var.tmp]]
  }
  
  
  
  state <- train_function(drop(Kx), drop(Kz), Y, parameters)
}
