#
# To test a Single Run of variable settings
#
# For questions and bug reports please contact
# suleiman.khan@aalto.fi or khan.suleiman@gmail.com
#
# Copyright 2013 Suleiman Ali Khan. All rights reserved.
# Citation: Suleiman A. Khan, Eemeli Leppäaho, Samuel Kaski, Multi-Tensor Factorization http://arxiv.org/abs/1412.4679.

# Clear the environment
rm(list=ls())

# Load Libraries
require(compiler)
require(tensor)

# Read in the code
source("MTF.R")
source("tools_test.R")

M = 2
L = 10
N = 20
D = c(30,31)
SNR = rep(2,length(D))

CP <- getVisualComponents.Demo(N,N,L,D,M)
IsMat=c(1,0) #one matrix and one tensor view
tensor.data <- data.train.test.1(IsMat,CP,SNR,normTotalVar=TRUE)

K <- ncol(tensor.data$Z)
K <- K+1  # The number of components; should be high enough to capture
          # all of the components. This can be recognized by at least a few
          # of the components being shut down

Y = tensor.data$Y	
opts <- getDefaultOpts(tensor.data$Y)
model <- MTF(Y,IsMat,K,opts) #Run the model
model.mean = getPosteriorMean(model)$rs.mean # Get Posterior Expected Value

## Print Learned View-Component Activity
print("Learned View-Component Activity")
Z = model.mean$Z
colnames(Z) = paste("Comp",1:ncol(Z),sep=".")
rownames(Z) = c("View.1 (Matrix)","View.2 (Tensor)")
print(Z)

