# Copyright (C) 2009-2011 Tommi Suvitaival and Ilkka Huopaniemi
#
# This file is part of multiWayCCA.
#
# multiWayCCA is free software: you can redistribute it and/or modify
# it under the terms of the Lesser GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# multiWayCCA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with multiWayCCA.  If not, see <http://www.gnu.org/licenses/>.


# rm(list=ls()) # Empty the workspace from other variables.
options(error=recover) # debug mode

## Function parameters

# The root folder of the package:
# The source code and data should be located in subdirectories "sourcecode" and "data", respectively. The results will be saved into subdirectory "results". This script should be saved to subdirectory "scripts".
path = getwd()
# path = "/share/mi/workspace/tsuvitai/mi/field/multiWayCCA-package-110202/" # The user may also set a directory that is not the working directory of R.

# A unique ID for the computation:
# The program will save the results into a subdirectory of "results" named after this argument.
runId = "multiWayCCA-110202-example"

# File names for the data:
# The files are assumed to be found from the 'data' folder of the given directory path.
# A data table with p+1 rows (variables) and n+1 columns (samples). By default, the first row and column contain the names of samples and variables, respectively. If the data files do not include names for samples or variables, the user will need to edit the arguments of the read.table function below.
dataXfile = 'dataX.csv' # source X
dataYfile = 'dataY.csv' # source Y
covariatesFile = 'covariates.csv' # 1 to 4 covariates (a, b, c, d)

NburnIn = 10000 # Length of the burn-in; remember to ensure sufficient burn-in for the sampler.
Niterfinal = 10000 # Number of iterations; remember to ensure sufficient number of samples from the posterior.

# Dimensionalities of the source-specific latent variables: positive integer values '1...pX' and '1...pY' accepted, or 'NA', which implies that variables from the source are not clustered but used directly (such as clinical variables).
nXlat = 4 # source X
nYlat = NA # source Y

# logarithm transformation of the data (TRUE/FALSE)
takeLog = list() # Do not edit this line.
takeLog$X = FALSE # source X
takeLog$Y = FALSE # source Y

# Estimated covariate effects:
# The user may set covariate effects by changing these parameters (TRUE/FALSE).
# If there are less than 4 covariates, the effects corresponding to the missing covariates are set off automatically.
sampleEff = list()
sampleEff$A = TRUE
sampleEff$B = TRUE
sampleEff$C = TRUE
sampleEff$D = TRUE
sampleEff$AB = TRUE
sampleEff$AC = TRUE
sampleEff$AD = TRUE
sampleEff$BC = TRUE
sampleEff$BD = TRUE
sampleEff$CD = TRUE
sampleEff$ABC = TRUE
sampleEff$ABD = TRUE
sampleEff$ACD = TRUE
sampleEff$BCD = TRUE
sampleEff$ABCD = TRUE

doPlotting = TRUE # Do/do not perform plotting of results (TRUE/FALSE).

## Load the package
# Do not edit.

if (substr(x=path, start=nchar(path), stop=nchar(path))!="/") # Make sure that the given path ends with character "/". Do not edit.
	path = paste(path,"/", sep="")
source(paste(path,"sourcecode/loadSource-110202.R",sep="")) # Load the function that loads other source code. Do not edit.
loadSource(path=path) # Load the source code. Do not edit.

## Load the data
# Function calls for reading the data tables. The user may need to edit this, if the data files are not in similar format as in the example.

data = list() # Do not edit this line.
pathData = paste(path,"data/", sep="") # Generate the directory path based on the argiments given by the user.
data$X = read.table(file=paste(pathData,dataXfile,sep=""), header=TRUE, sep=",", dec=".", row.names=1) # Load source X.
data$Y = read.table(file=paste(pathData,dataYfile,sep=""), header=TRUE, sep=",", dec=".", row.names=1) # Load source Y.
data$covariates = read.table(file=paste(pathData,covariatesFile,sep=""), header=TRUE, sep=",", dec=".", row.names=1) # Load 1 to 4 covariates.

## Run the sampler

result = multiWayCCA(data=data, nXlat=nXlat, nYlat=nYlat, sampleEff=sampleEff, takeLog=takeLog, maxBurnIn=NburnIn, Niterfinal=Niterfinal, path=path, runId=runId) # Do not edit.
