# 21.10.10 - 3-way version; covariate arguments renamed

plot_cor = function(x, covA, covB, covC, VV, Vmode, path) {

	# 27.10.09 - new version to deal with multi-level two-way data
	# 
	if (as.numeric(R.version$major)>=2 & as.numeric(R.version$minor)>=11) {
		plotType = NULL # 22.7.10 for R-2.11.0'
	} else {
		plotType = "cairo1"
	}

	# K = ncol(Vs) # Number of clusters -16.3.09
	K = ncol(Vmode) # Number of clusters -19.2.10
		#VV=t(as.matrix(VV))

	mod = 5
	corres_length = floor(dim(VV)[3]/mod)
	corres = matrix(0,nrow=corres_length,ncol=K)
	Vsums = matrix(nrow=corres_length,ncol=K)
	# V_posterior = Vs/dim(VV)[3]
	# V_mode = (V_posterior==apply(V_posterior,1,max))*1

	for (i in 1:max(covA)) {
		for (j in 1:max(covB)) {
			for (l in 1:max(covC)) {
				if (length(which(covA==i & covB==j & covC==l))>1) {
					corres = corres*NA
					x_ijl = x[,covA==i & covB==j & covC==l]
					for (c in 1:corres_length) {
						cm = c*mod
						corres[c,] = corre_means(x_ijl,VV[,,cm])
						if (K==1) { # If only one cluster, only sum needs to be calculated.
							Vsums[c,] =  sum(VV[,,cm])
						} else { # If more than one cluster, colSums need to be calculated.
							Vsums[c,] =  colSums(VV[,,cm]) # 'samples' not passed to the function -16.3.09
						}
					}
		# 			png(paste(path,"cor-",cor_labels[j],".png",sep=""), width=840,height=840,type="cairo1")
		# 			png(paste(path,"cor-",case,i,gender,j,".png",sep=""), width=600, height=200*K, type="cairo1")
					png(paste(path,"cor-a",i,"b",j,"c",l,".png",sep=""), width=600, height=200*K, type=plotType) # 19.2.10
		# 			layout(t(matrix(1:30,nrow=6)))
					layout(matrix(1:(3*K),nrow=K))
					# Piirretään klusterien kovarianssimatriisit.
		# 			show_clusters(x,V_mode)
					show_clusters(x_ijl,Vmode) # 19.2.10
					# Piirretään 'subplotiin' em. aikasarjat kullekin klusterille 'k'.
					for (k in 1:K) {
						screen(K+k)
						plot(Vsums[,k], type="l", col='blue', ylim=c(0,max(Vsums)), main=sprintf('N, K=%d',k))
					}
					for (k in 1:K) {
						screen(2*K+k)
						plot(corres[,k],type="l",col='magenta',ylim=c(0,1), main=sprintf('Cor, K=%d',k))
					}
					dev.off()
				}
			}
		}
	}

}

##########
##########

# Funktio 'corre_means'
# Tommi Suvitaival, 11.06.08
# Tehtävä: 
# Laskee klusteroidun datan klusterikohtaisten korrelaatioiden itseisarvon odotusarvon.
# Voidaan käyttää apuna konvergenssidiagnostiikassa.
# Parametrit:
# xxx - data (nrow='näytteiden lkm', ncol='näytteiden dimensio')
# VVV - klusterointi eli binäärinen matriisi, joka kertoo,
# 		  mihin klusteriin xxx:n osoittama vastaava datapiste kuuluu.
#		  Datapiste voi kuulua ainoastaan yhteen klusteriin.
#
# History:
# 27.3.09 - Handling for only one cluster added. In that case, the clusterin matrix is in fact a vector, and thus, only one correlation value is obtained.

corre_means = function(x,V) {
	
	#print(dim(V))
	#print("K");print(K)
	
	#print("m");print(m)
	klusteri <- array()
	#print(dim(V))
	# Käydään läpi kaikki 'K' klusteria.
	if (is.vector(V)) { # only one cluster
		M = length(V)
		# The data needs to be submitted to function 'cor' in matrix form, when auto-correlations are to be computed.
		corre_means = (sum(abs(cor(matrix(V))))-M)/(M^2-M)
	} else {
		K <- ncol(V) # Klusterien lukumäärä
		corre_means <- matrix(nrow=K,ncol=1)
		for (k in 1:K) {
			# Etsitään datamatriisista klusteriin 'k' kuuluvat näytteet.
			# Jotta voidaan laskea korrelaatio, on klusterissa oltava
			# enemmän kuin yksi näyte.
			if (sum(V[,k]==1)>1) {
				if (k==6) {
					#print(sum(V[,k]==1))
				}
				klusteri <- t(x[(V[,k]==1),])
				#print(dim(klusteri))
				# Lasketaan klusterin näytteiden
				# korrelaation itseisarvon odotusarvo.
				# 1. Muodostetaan klusterin näytteiden korrelaatiomatriisi.
				# 2. Otetaan korrelaatioista itseisarvot,
				#    koska ei haluta tehdä eroa 
				#	  positiivisen ja negatiivisen korrelaation välillä.
				# 3. Lasketaan korrelaatioiden klusterikohtainen keskiarvo.
				# 4. Poistetaan diagonaalilla oleva 1-korrelaatio keskiarvosta.
				#	  Otetaan siis huomioon vain diagonaalin ulkopuoliset näytteet.
				# 5. Kaava on sievennetty.

				# Kaava ilman diagonaalialkioiden poistoa keskiarvosta.
				# corre_means[k] = mean(abs(cor(klusteri)))

				M = ncol(klusteri)
				#print(dim(klusteri))
				corre_means[k] = (sum(abs(cor(klusteri)))-M)/(M^2-M)
			} else {
				# Jos klusterissa ei ole yhtään näytettä, asetetaan korrelaatioksi 0.
				#print("nollaa")
				corre_means[k] = 0
			}
		}
	}
	return(corre_means)
	
}
