# Copyright (C) 2010 Tommi Suvitaival and Ilkka Huopaniemi
#
# This file is part of multiWayCCA.
#
# multiWayCCA is free software: you can redistribute it and/or modify
# it under the terms of the Lesser GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# multiWayCCA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with multiWayCCA.  If not, see <http://www.gnu.org/licenses/>.


# Input:
# cors - nZ x Nps matrix, where nZ is the number of correlations and Nps the number of posterior samples

plotCancors = function(cors,file,trueCors=NULL) {

	Ncors = nrow(cors)
	png(paste(file,".png",sep=""),width=640,height=640,type="cairo1")
	layout(matrix(1:Ncors,nrow=1,byrow=T))
	for (i in 1:Ncors) {
		screen(i)
		boxplot(cors[i,],ylim=c(0,1))
		if (!is.null(trueCors)) {
			abline(h=trueCors[i],col="red")
		}
	}
	dev.off()

}
