# Copyright (C) 2010 Tommi Suvitaival and Ilkka Huopaniemi
#
# This file is part of multiWayCCA.
#
# multiWayCCA is free software: you can redistribute it and/or modify
# it under the terms of the Lesser GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# multiWayCCA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with multiWayCCA.  If not, see <http://www.gnu.org/licenses/>.


plotSurface = function(X,file,Xtrue=NULL) {

	if (as.numeric(R.version$major)>=2 & as.numeric(R.version$minor)>=11) {
		plotType = NULL # 22.7.10 for R-2.11.0'
	} else {
		plotType = "cairo1"
	}

	ymar = 1:nrow(X)
	if (!is.null(Xtrue)) {
		xmar = 1:(2*ncol(X))
		png(paste(file,".png",sep=""),width=50*ncol(X),height=20*nrow(X),type=plotType)
		image(xmar,ymar,t(cbind(X,Xtrue)))
	} else {
		xmar = 1:ncol(X)
		png(paste(file,".png",sep=""),width=50*ncol(X),height=20*nrow(X),type=plotType)
		image(xmar,ymar,t(X))
	}
	dev.off()

}
