package jmprojection;

/**
 * Interface describing just one method, a method needed for the curvilinear
 * mapping algorithms.
 * @author Jarkko Miettinen
 */
public interface Curvilinear {

	/**
	 * calculates distances between every centroid pair (c[i],c[j]) in original
	 * space and projection space and returns K x 2 array, where array[m][0] is
	 * the distance in original space ("dx") and array[m][1] the distance in
	 * projection space ("dy") for every m=0..K-1. K is n*(n+1)/2 where n is
	 * number of centroids.
	 * @return pair-wise distance-matrix
	 */
	public double[][] getDyDxError();

}
