/*
 * Copyright 2006-2011 The MZmine 2 Development Team
 * 
 * This file is part of MZmine 2.
 * 
 * MZmine 2 is free software; you can redistribute it and/or modify it under the
 * terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 * 
 * MZmine 2 is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 * A PARTICULAR PURPOSE. See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * MZmine 2; if not, write to the Free Software Foundation, Inc., 51 Franklin St,
 * Fifth Floor, Boston, MA 02110-1301 USA
 */

import net.sf.mzmine.desktop.impl.MainWindow;
import net.sf.mzmine.main.MZmineCore;
import net.sf.mzmine.taskcontrol.TaskControlListener;
import net.sf.mzmine.util.ExitCode;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent.AboutEvent;
import com.apple.eawt.AppEvent.QuitEvent;
import com.apple.eawt.Application;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;

/**
 * This class configures Mac-specific desktop features
 * 
 */
public class MacSpecificSetup implements AboutHandler, QuitHandler,
		TaskControlListener {

	private Application myMacApp;

	public void init() {

		myMacApp = Application.getApplication();
		myMacApp.setAboutHandler(this);
		myMacApp.setQuitHandler(this);

		MZmineCore.getTaskController().addTaskControlListener(this);

	}

	@Override
	public void handleQuitRequestWith(QuitEvent event, QuitResponse response) {
		ExitCode exitCode = MZmineCore.getDesktop().exitMZmine();
		if (exitCode == ExitCode.OK)
			response.performQuit();
		else
			response.cancelQuit();
	}

	@Override
	public void handleAbout(AboutEvent e) {
		MainWindow mainWindow = (MainWindow) MZmineCore.getDesktop();
		mainWindow.showAboutDialog();
	}

	@Override
	public void numberOfWaitingTasksChanged(int numOfTasks) {
		String badge = null;
		if (numOfTasks > 0)
			badge = String.valueOf(numOfTasks);
		myMacApp.setDockIconBadge(badge);
	}

}
