package jmprojection;

/**
 * 
 * This class enables canceling and querying status of on-going projection.
 * Needed for example with methods that don't use iterate() like PCA. This
 * class was added afterwards to Jarkko's original library.
 * 
 */
public class ProjectionStatus {

	private boolean canceled = false;
	private float finishedPercentage = 0.0f;

	protected boolean isCanceled() {
		return canceled;
	}

	public void cancel() {
		canceled = true;
	}

	public float getFinishedPercentage() {
		return finishedPercentage;
	}

	protected void setFinishedPercentage(float finishedPercentage) {
		this.finishedPercentage = finishedPercentage;
	}

}
