create3wayDesignMatrixWithEffects = function(covA, covB, covC, eff=NULL) {


	## PeakANOVA: Stronger findings from mass spectral data through multi-peak modeling
	## A function for creating a design matrix from the covariate indicator vectors.

	## Copyright 2013 Tommi Suvitaival
	# Email: tommi.suvitaival@aalto.fi

	# This file is part of PeakANOVA.

	# PeakANOVA is free software: you can redistribute it and/or modify
	# it under the terms of the GNU Lesser General Public License as published by
	# the Free Software Foundation, either version 3 of the License, or
	# (at your option) any later version.

	# PeakANOVA is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU Lesser General Public License for more details.

	# You should have received a copy of the GNU Lesser General Public License
	# along with PeakANOVA.  If not, see <http://www.gnu.org/licenses/>.


	A = max(covA)
	B = max(covB)
	C = max(covC)

	design = array(data=0, dim=c(length(covA),(A+B+C+A*B+A*C+B*C+A*B*C)))
	if (!is.null(eff))
		effMat = array(data=NA, dim=c(ncol(design),ncol(eff$A)))
	else
		effMat = NULL
	
	ind = list()
	ind$vec = list()
	ind$tab = list()
	ind$tab$A = 1:A
	ind$vec$A = ind$tab$A
	if (!is.null(effMat))
		effMat[1:A,] = eff$A
	ind$tab$B = A+(1:B)
	ind$vec$B = ind$tab$B
	if (!is.null(eff))
		effMat[A+(1:B),] = eff$B
	ind$tab$C = A+B+(1:C)
	ind$vec$C = ind$tab$C
	if (!is.null(eff))
		effMat[A+B+(1:C),] = eff$C
	
	ind$tab$AB = array(dim=c(A,B))
	ind$tab$AC = array(dim=c(A,C))
	ind$tab$BC = array(dim=c(B,C))
	ind$tab$ABC = array(dim=c(A,B,C))

	for (ai in 1:A) {
		design[covA==ai,ai] = 1 # 1
		ind$tab$AB[ai,] = A+B+C+(ai-1)*B+(1:B)
		ind$vec$AB = c(ind$vec$AB,ind$tab$AB[ai,])
		ind$tab$AC[ai,] = A+B+C+A*B+(ai-1)*C+(1:C)
		ind$vec$AC = c(ind$vec$AC,ind$tab$AC[ai,])
		if (!is.null(eff)) {
			effMat[A+B+C+(ai-1)*B+(1:B),] = eff$AB[ai,,]
			effMat[A+B+C+A*B+(ai-1)*C+(1:C),] = eff$AC[ai,,]
		}
		for (bi in 1:B) {
			design[covB==bi,A+bi] = 1 # 2
			design[covA==ai&covB==bi,A+B+C+(ai-1)*B+bi] = 1 # 4
			if (ai==1) {
				ind$tab$BC[bi,] = A+B+C+A*B+A*C+(bi-1)*C+(1:C)
				ind$vec$BC = c(ind$vec$BC,ind$tab$BC[bi,])
				effMat[A+B+C+A*B+A*C+(bi-1)*C+(1:C),] = eff$BC[bi,,]
			}
			ind$tab$ABC[ai,bi,] = A+B+C+A*B+A*C+B*C+(ai-1)*(B*C)+(bi-1)*C+(1:C)
			ind$vec$ABC = c(ind$vec$ABC,ind$tab$ABC[ai,bi,])
			if (!is.null(eff))
				effMat[A+B+C+A*B+A*C+B*C+(ai-1)*(B*C)+(bi-1)*C+(1:C),] = eff$ABC[ai,bi,,]
			for (ci in 1:C) {
				design[covC==ci,A+B+ci] = 1 # 3
				design[covA==ai&covC==ci,A+B+C+A*B+(ai-1)*C+ci] = 1 # 5
				design[covB==bi&covC==ci,A+B+C+A*B+A*C+(bi-1)*C+ci] = 1 # 6
				design[covA==ai&covB==bi&covC==ci,A+B+C+A*B+A*C+B*C+(ai-1)*(B*C)+(bi-1)*C+ci] = 1 # 7
			}
		}
	}

	if (is.null(eff))
		return(list(mat=design, ind=ind))
	else
		return(list(mat=design, ind=ind, eff=effMat))

}