findLSclustering = function(V.vec, return.association.avg=FALSE) {

	## PeakANOVA: Stronger findings from mass spectral data through multi-peak modeling
	## A function for finding the least-squares clustering among Gibbs samples

	## Copyright 2013 Tommi Suvitaival
	# Email: tommi.suvitaival@aalto.fi

	# This file is part of PeakANOVA.

	# PeakANOVA is free software: you can redistribute it and/or modify
	# it under the terms of the GNU Lesser General Public License as published by
	# the Free Software Foundation, either version 3 of the License, or
	# (at your option) any later version.

	# PeakANOVA is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU Lesser General Public License for more details.

	# You should have received a copy of the GNU Lesser General Public License
	# along with PeakANOVA.  If not, see <http://www.gnu.org/licenses/>.


	## Description
	# -A function for finding the least-squares clustering among Gibbs samples

	## Arguments
	# V.vec - PxS - array of posterior samples for clustering - posterior samples x objects
	
	
	## Source code

	## Compute the average association matrix from posterior samples.

	association.avg = array(data=0, dim=c(1,1)*ncol(V.vec))
	for (ni in 1:nrow(V.vec)) { # Go through all posterior samples.
		for (ki in 1:max(V.vec[ni,])) { # Go through all clusters.
			variables.ki = which(V.vec[ni,]==ki)
			if (length(variables.ki)>0) {
				association.avg[variables.ki,variables.ki] = association.avg[variables.ki,variables.ki]+1
			}
		}
	}
	association.avg = association.avg/nrow(V.vec)

	## Compute the deviation of each posterior sample from the average association matrix.

	association.deviation = rep(x=NA, times=nrow(V.vec))
	association.ni = array(data=0, dim=c(1,1)*ncol(V.vec))
	for (ni in 1:nrow(V.vec)) { # Go through all posterior samples
		association.ni[] = 0
		for (ki in 1:max(V.vec[ni,])) { # Go through all clusters ki in Gibbs sample ni.
			variables.ki = which(V.vec[ni,]==ki)
			if (length(variables.ki)>0) {
				association.ni[variables.ki,variables.ki] = 1
			}
		}
		association.deviation[ni] = sum((association.ni-association.avg)^2)
	}
	
	## Find the smallest deviation from the average association matrix and return the corresponding clustering matrix.
	
	ind.clustering.optimal.association = which.min(association.deviation)
	K.optimal.association = max(V.vec[ind.clustering.optimal.association,])
	V.optimal = array(data=0, dim=c(ncol(V.vec),K.optimal.association))
	for (ki in 1:K.optimal.association) { # Reconstruct the clustering matrix from the saved vector.
		V.optimal[which(V.vec[ind.clustering.optimal.association,]==ki),ki] = 1
	}
	
	if (return.association.avg) {
		return(list(V.ls=V.optimal, association.avg=association.avg))
	} else {
		return(V.optimal)
	}

}