getDefaultParamPeakAnova = function() {


	## PeakANOVA: Stronger findings from mass spectral data through multi-peak modeling
	## Function for setting default parameters

	## Copyright 2013 Tommi Suvitaival
	# Email: tommi.suvitaival@aalto.fi

	# This file is part of PeakANOVA.

	# PeakANOVA is free software: you can redistribute it and/or modify
	# it under the terms of the GNU Lesser General Public License as published by
	# the Free Software Foundation, either version 3 of the License, or
	# (at your option) any later version.

	# PeakANOVA is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU Lesser General Public License for more details.

	# You should have received a copy of the GNU Lesser General Public License
	# along with PeakANOVA.  If not, see <http://www.gnu.org/licenses/>.


	## Value:
	# param: A list of parameters for the PeakANOVA model.


	param = list()

	## Random seed

	param$rnd.seed = as.integer(Sys.time()+Sys.getpid()) # Set a unique seed based on time and process id.
	set.seed(seed=param$rnd.seed)

	## Gibbs sampler
	
	param$Nburnin = 1000 # number of burn-in iterations
	param$Npsamples = 1000 # number of iterations after burn-in
	param$Npsaved = 1000 # number of Gibbs samples saved after burn-in
	
	## Clustering
	
	param$clustering = TRUE
	param$nonparametric.clustering = TRUE
	param$missing.data = TRUE
	
	# Save clustering matrix from each Gibbs sample as an indicator vector.
	if (param$nonparametric.clustering) {
		param$saveVvec = FALSE
	} else {
		param$saveVvec = TRUE
		param$saveV = FALSE # Save clustering matrix from each Gibbs sample.
	}
	param$saveVadjacency = FALSE # Save the average adjacency matrix of clustered variables over the Gibbs samples.
	
	param$shapes.beta = list()
	param$shapes.beta$inside =  c(2,1)
	param$shapes.beta$outside = c(1,1)

	param$alpha.dp = 1 # Dirichlet process concentration parameter
	
	## Second level of clustering (additional non-documented feature)

	param$two.levels.clustering = FALSE
	
	if (param$two.levels.clustering) {
		param$saveW = FALSE
		param$saveWvec = TRUE
		param$saveWadjacency = TRUE
		param$saveVWadjacency = TRUE
		param$saveZ = FALSE
		param$psi$psi0 = 1
		param$psi$N0 = 1
	}
	
	## ANOVA-type model
	
	param$sampleEff = list()
	param$sampleEff$A = c(FALSE, TRUE)
	param$sampleEff$B = FALSE
	param$sampleEff$C = FALSE
	param$sampleEff$AB = FALSE
	param$sampleEff$AC = FALSE
	param$sampleEff$BC = FALSE
	param$sampleEff$ABC = FALSE

	param$sampleSigma = TRUE

	param$saveXlat = FALSE # Save the latent variable from each Gibbs sample.
	
	# Fixed covariate effects (additional non-documented feature)
	
	param$fixed = list()
	param$fixed$V = NULL
	param$fixed$eff = list()
	param$fixed$eff$A = NULL
	param$fixed$eff$B = NULL
	param$fixed$eff$C = NULL
	param$fixed$eff$AB = NULL
	param$fixed$eff$AC = NULL
	param$fixed$eff$BC = NULL
	param$fixed$eff$ABC = NULL

	param$silent = FALSE

	# If using parametric clustering, define the number of clusters and their prior probabilities.
	if (!param$nonparametric.clustering) {
		param$K = 10 # number of clusters
		param$L = param$K
		# Cluster prior probabilities
		param$theta = list()
		param$theta$K <- array(1/param$K,dim=c(param$K,1))
		param$theta$L <- array(1/param$L,dim=c(param$L,1))
	}
	
	param$sigma = list()
	param$sigma$sigma0 = 1 # prior value of sigma
	param$sigma$N0 = 1 # number of prior samples for sigma

	return(param)

}