loadSourcePeakAnova = function(path=getwd()) {


	## PeakANOVA: Stronger findings from mass spectral data through multi-peak modeling
	## Function for loading the source files of the package

	## Copyright 2013 Tommi Suvitaival
	# Email: tommi.suvitaival@aalto.fi

	# This file is part of PeakANOVA.

	# PeakANOVA is free software: you can redistribute it and/or modify
	# it under the terms of the GNU Lesser General Public License as published by
	# the Free Software Foundation, either version 3 of the License, or
	# (at your option) any later version.

	# PeakANOVA is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU Lesser General Public License for more details.

	# You should have received a copy of the GNU Lesser General Public License
	# along with PeakANOVA.  If not, see <http://www.gnu.org/licenses/>.


	## Load libraries.

	library("gtools") # function "permute"
	library("MASS")
	library("mvtnorm")
	library("stats")

	## Load functions.

	source(file.path(path, "peakANOVA-cluster.R")) # clustering
	source(file.path(path, "peakANOVA-create3wayDesignMatrixWithEffects.R")) # function for creating a design matrix from the covariate vectors
	source(file.path(path, "peakANOVA-functionsDR.R")) # sampler functions the latent variable model
	source(file.path(path, "peakANOVA-findLSclustering.R")) # function for finding the least squares clustering
	source(file.path(path, "peakANOVA-generateSimulatedData.R")) # data generation
	source(file.path(path, "peakANOVA-getDefaultParam.R")) # parameters
	source(file.path(path, "peakANOVA-multiWayDR.R")) # sampler main function for the inference of covariate effects
	source(file.path(path, "peakANOVA-normalizeDataByControlPopulation.R")) # data normalization
	source(file.path(path, "peakANOVA-preComputeQlikeSum.R")) # likelihood of observed peak shape correlations
	source(file.path(path, "peakANOVA-sampleEffMat.R")) # sampler function for inferring the covariate effects

	return(TRUE)

}