sampleEffMat = function(z, design, effects, sampleLevels, multiWay=TRUE, prior.var=NULL) {


	## PeakANOVA: Stronger findings from mass spectral data through multi-peak modeling
	## Function for sampling the covariate effects

	## Copyright 2013 Tommi Suvitaival
	# Email: tommi.suvitaival@aalto.fi

	# This file is part of PeakANOVA.

	# PeakANOVA is free software: you can redistribute it and/or modify
	# it under the terms of the GNU Lesser General Public License as published by
	# the Free Software Foundation, either version 3 of the License, or
	# (at your option) any later version.

	# PeakANOVA is distributed in the hope that it will be useful,
	# but WITHOUT ANY WARRANTY; without even the implied warranty of
	# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	# GNU Lesser General Public License for more details.

	# You should have received a copy of the GNU Lesser General Public License
	# along with PeakANOVA.  If not, see <http://www.gnu.org/licenses/>.


	eff = array(data=NA, dim=c(length(sampleLevels),ncol(effects)))
	eff0 = rep(x=NA, times=nrow(z))
	sizePopu = NA

	for (i in 1:length(sampleLevels)) { # Go through all levels of the covariate.
		popu = which(design[,sampleLevels[i]]==1)
		sizePopu = length(popu)
		if (sizePopu>0) {
			if (multiWay) {
				eff0 = rowSums(as.matrix(z[,popu]-t(design[popu,-sampleLevels]%*%effects[-sampleLevels,]), nrow=K))
			} else {
				eff0 = rowSums(as.matrix(z[,popu],nrow=K))
			}
			if (is.null(prior.var)) {
				eff0 = eff0/(sizePopu+1)
				eff[i,] = rnorm(n=length(eff0), mean=eff0, sd=sqrt(1/(1+sizePopu))) # sampling
			} else {
				eff0 = eff0/prior.var/(1+sizePopu/prior.var)
				eff[i,] = rnorm(n=length(eff0), mean=eff0, sd=sqrt(1/(1+sizePopu/prior.var))) # sampling
			}
		} else {
			eff[i,] = rep(x=0, times=K)
		}
	}
	
	return(eff)
	
}
