%This script learns the VB-MoG model using the L-BFGS algorithm for means
%and gammas. Refer to the demonstration scripts named
%MoG_comparison_experiment_# for usage of this script. The parameters of
%the learned model are stored in variables mean, W, v, alpha and beta.
%The cost function values and corresponding CPU times are stored in the
%variable costValues_m_gamma_bfgs. The L-BFGS-B implementation by Peter
%Carbonetto is required to be installed.
%Copyright (C) 2008-2010 Mikael Kuusela.

disp('-----------------');
disp('m gamma grad bfgs');

path('./../bfgs',path);

global costValues_m_gamma_bfgs;

global f_calls;
global g_calls;
f_calls = 0;
g_calls = 0;

%Initialize number of components
K = initK;

%Initialize parameters
W = initW;
v = initV;
beta = initBeta;
alpha = initAlpha;
mean = initMean;

%Initial values for pi_eff and lambda_eff   
pi_eff = exp(psi(alpha)-psi(sum(alpha)));
lambda_eff = zeros(1,K);
for k=1:K
    temp = 0;
    for i=1:D
        temp = temp + psi((v(k) + 1 - i)/2);
    end
    lambda_eff(k) = exp(temp + D*log(2) + log(det(W(:,:,k))));
end

t = cputime;

%Calculate gammas
gamma = zeros(N,K);
for n=1:N
    for k=1:K
        gamma(n,k) = log(pi_eff(k)*sqrt(lambda_eff(k))*exp(-D/(2*beta(k))-v(k)/2*(X(:,n)-mean(:,k))'*W(:,:,k)*(X(:,n)-mean(:,k))));
    end
end

const_gamma = gamma(:,end); %Fix one gamma for each data point
var_gamma = gamma(:,1:end-1);
auxdata = {alpha_0, beta_0, v_0, W_0, invW_0, mean_0, K, N, X, D, const_gamma, t, run};
%L-BFGS iteration with memory length m_bfgs
[mean var_gamma] = lbfgsb({mean var_gamma}, {repmat(-inf,D,K) repmat(-inf,N,K-1)},...
                          {repmat(inf,D,K) repmat(inf,N,K-1)}, 'bfgs_cost_wrapper',...
                          'bfgs_grad_wrapper', auxdata,'bfgs_callback_wrapper',...
                          'factr',epsilon/300,'maxiter',10000,'pgtol',0,'m',m_bfgs);

%Calculate learned model
gamma = [var_gamma const_gamma];
res = gamma_to_res(gamma, auxdata);
helper = bfgs_helper_values(res, auxdata);
[N_eff, x_avg, S, alpha, beta, v, W, pi_eff, lambda_eff] = helper{:};
cost = costFunction(alpha_0, beta_0, v_0, W_0, invW_0, mean_0, res, N_eff, x_avg, S, alpha, beta, mean, v, W, pi_eff, lambda_eff, K, N, D);

%Save image segments
if imageData == true
    for k=1:K
        writeImageData(res,k,x_pixs,N,strcat(filename,'_segmented_m_gamma_bfgs_',num2str(run),'_',num2str(k),'.png'),'png');
    end
end