%This script compares VB EM, pattern search, NG and NCG with different
%values of R in the cluster experiment.
%Copyright (C) 2008-2010 Mikael Kuusela.

for r=0:0.025:1 %Loop over R values

    experiment = 200+40*r;

    imageData = false; %True uses image data
    plot_MoG = false; %True plots the MoG model
    randomMeans = true; %Initialize means of means randomly, otherwise place on top of a random data point

    seed = 1974297; %Seed for random number generators
    rand('state',seed);
    randn('state',seed);

    warning off;

    if imageData == true
        %Use image data
        filename = 'swan.jpg';
        type = 'jpg';
        [X N D x_pixs y_pixs] = getImageData(filename, type);
    else
        %Use artificial data
        N=1000; %Number of data points
        D=2; %Dimensionality of the data
        X = generateData_cluster(N,D,r); %Generate the data
    end

    initK=8; %Initial number of Gaussians
    nRuns = 30; %Number of runs

    %Termination criteria
    epsilon = 1e-8*N;
    requiredTermCount = 2;

    %Removal criteria
    removalCriteria = 0.1;

    %Initial values for parameters
    initAlpha = ones(1,initK);
    initBeta = 10*ones(1,initK);
    initV = ones(1,initK)*D;
    initW = 4/D*repmat(eye(D),[1 1 initK]);

    %Parameters for priors
    alpha_0 = 1;
    beta_0 = 1;
    v_0 = D;
    W_0 = 4/D*eye(D);
    mean_0 = zeros(D,1);

    invW_0 = inv(W_0);

    clear costValues*;

    for run=1:nRuns
        if randomMeans == true
            %Initialize means of means randomly
            initMean=random('Normal',0,0.4,D,initK);
        else
            %Initialize means on top of a randomly selected data point
            randDataPoint = randint(1,initK,[1,N]);
            initMean = zeros(D,initK);
            for k=1:initK
                initMean(:,k) = X(:,randDataPoint(k));
            end
        end

        %save(strcat('./temp/experiment_',num2str(experiment),'_initial_',num2str(run)),'X','initMean');

        MoG_VB_EM;
        %save(strcat('./temp/experiment_',num2str(experiment),'_VB_EM_end_',num2str(run)),'cost','K','mean','W','v','alpha','beta');
        MoG_VB_EM_pattern_search;
        %save(strcat('./temp/experiment_',num2str(experiment),'_VB_EM_pattern_search_end_',num2str(run)),'cost','K','mean','W','v','alpha','beta');    

        initT3 = 2; %Step length for line search
        MoG_VB_m_gamma_nat_grad;
        %save(strcat('./temp/experiment_',num2str(experiment),'_m_gamma_nat_grad_end_',num2str(run)),'cost','K','mean','W','v','alpha','beta');      
        MoG_VB_m_gamma_nat_conj_grad_PR_Riemann;
        %save(strcat('./temp/experiment_',num2str(experiment),'_m_gamma_nat_conj_grad_PR_Riemann_end_',num2str(run)),'cost','K','mean','W','v','alpha','beta');

        %save(strcat('./temp/experiment_',num2str(experiment),'_',num2str(run)), 'costValues*');
    end

    %Save cost function values and the associated training times
    save(strcat('experiment_',num2str(experiment)), 'costValues*');

end
