function helper = bfgs_helper_values(res, auxdata)
%Calculate helper values based on responsibilities
%Copyright (C) 2008-2010 Mikael Kuusela.

[alpha_0, beta_0, v_0, W_0, invW_0, mean_0, K, N, X, D, const_gamma, t, run] = auxdata{:};

%Calculate helper values
N_eff = zeros(1,K);
for k=1:K
    N_eff(k) = sum(res(:,k));
end

x_avg = zeros(D,K);
S = zeros(D,D,K);
for k=1:K
    for n=1:N
        x_avg(:,k) = x_avg(:,k) + res(n,k)*X(:,n);
    end    
    x_avg(:,k) = x_avg(:,k) / N_eff(k);

    for n=1:N
        S(:,:,k) = S(:,:,k) + res(n,k)*(X(:,n) - x_avg(:,k))*(X(:,n) - x_avg(:,k))';
    end
    S(:,:,k) = S(:,:,k) / N_eff(k);
end

%Update distribution parameters for each Gaussian    
alpha = zeros(1,K);
beta = zeros(1,K);
v = zeros(1,K);
W = zeros(D,D,K);

for k=1:K
    alpha(k) = alpha_0 + N_eff(k);  
end

for k=1:K    
    beta(k) = beta_0 + N_eff(k);
end

for k=1:K    
    v(k) = v_0 + N_eff(k);
end

for k=1:K    
    W(:,:,k) = inv(invW_0 + N_eff(k) * S(:,:,k) + (beta_0 * N_eff(k)) / (beta_0 + N_eff(k)) * (x_avg(:,k) - mean_0) * (x_avg(:,k) - mean_0)');
end

%Calculate pi_eff and lambda_eff
pi_eff = exp(psi(alpha)-psi(sum(alpha)));
lambda_eff = zeros(1,K);
for k=1:K
    temp = 0;
    for i=1:D
        temp = temp + psi((v(k) + 1 - i)/2);
    end
    lambda_eff(k) = exp(temp + D*log(2) + log(det(W(:,:,k))));
end

helper = {N_eff, x_avg, S, alpha, beta, v, W, pi_eff, lambda_eff};