function res = gamma_to_res(gamma, auxdata)
%Transform gamma parameters to responsibilities
%Copyright (C) 2008-2010 Mikael Kuusela.

[alpha_0, beta_0, v_0, W_0, invW_0, mean_0, K, N, X, D, const_gamma] = auxdata{:};
res = zeros(N,K);
for n=1:N
    for k=1:K
        res(n,k) = exp(gamma(n,k));
    end    
    res(n,:) = res(n,:) / sum(res(n,:)); %Normalization
    
    normalization = false;
    for k=1:K
        if res(n,k) < 1e-10
            res(n,k) = 1e-10; %Avoid domain errors due to limited accuracy of floating point numbers
            normalization = true;
        end
    end
    if normalization == true
        res(n,:) = res(n,:) / sum(res(n,:)); %Normalization
    end
end