function [X,N,D,x_pixs,y_pixs] = getImageData(filename, type)
%Load an image and interpret each pixel as a data vector. Each data vector
%has two spacial coordinates x,y and three color coordinates r,g,b.
%Filename specifies the image to load and type the type of the image.
%Returns the data X, the number of samples N, data dimension D and the size
%of the image in x_pixs and y_pixs.
%Copyright (C) 2008-2010 Mikael Kuusela.

img = imread(strcat('./img/',filename),type);

x_pixs = size(img,2);
y_pixs = size(img,1);

N = x_pixs*y_pixs;
D = 5; %x,y,R,G,B

%Convert image data to proper format
X = zeros(5,N);
for n=1:N
    if mod(n,x_pixs) ~= 0
        x = mod(n,x_pixs);
        y = ceil(n/x_pixs);
    else
        x = x_pixs;
        y = n/x_pixs;
    end

    X(:,n) = [(x-1)/(x_pixs-1);(y-1)/(y_pixs-1);cast(squeeze(img(y,x,:)),'double')/255]; %Data in interval [0,1]
end

%Scale data to interval [-1,1]
X = (X-0.5)*2;