function r = ln_wishart_B(W,v)
%Calculate the logarithm of the normalization constant B of the Wishart
%distribution.
%Copyright (C) 2008-2010 Mikael Kuusela.

D = size(W,1);
r = 0;

for i=1:D
    r = r + gammaln((v+1-i)/2);
end

r = r + v/2 * log(det(W)) + v*D/2 * log(2) + D*(D-1)/4 * log(pi);
r = -r;