function writeImageData(res,k,x_pixs,N,filename,format)
%Save component responsibilities as images. Takes as an input the
%responsibility matrix res, the component to be plotted k, the number of
%pixels in the x direction x_pixs, the number of data points N and the name
%and the format of the output image.
%Copyright (C) 2008-2010 Mikael Kuusela.

data = res(:,k); %Use responsibilities as grayscale color values
img = zeros(N/x_pixs,x_pixs);

%Construct the image
for n=1:N
    if mod(n,x_pixs) ~= 0
        x = mod(n,x_pixs);
        y = ceil(n/x_pixs);
    else
        x = x_pixs;
        y = n/x_pixs;
    end

    img(y,x) = data(n);
end

%Write the image
imwrite(img, strcat('./img/',filename), format);
