function E = grad_E(res, pi_eff, lambda_eff, D, beta, v, X, mean, W, N, K)
%Calculate E_nk used to evaluate the gradient
%Copyright (C) 2008-2010 Mikael Kuusela.

E = zeros(N,K);
G = zeros(1,K);

for k=1:K
    G(k) = log(pi_eff(k)) + 1/2*(log(lambda_eff(k))-D/beta(k)-D*log(2*pi));
end

for i=1:N
    for k=1:K
        E(i,k) = res(i,k)*(log(res(i,k))+v(k)/2*(X(:,i)-mean(:,k))'*W(:,:,k)*(X(:,i)-mean(:,k))-G(k));
        %E(i,k) = res(i,k)*(log(res(i,k)+eps)+v(k)/2*(X(:,i)-mean(:,k))'*W(:,:,k)*(X(:,i)-mean(:,k))-G(k)); %NB: eps in log
    end
end