function X = generateData_cluster(N, D, r)
%Generate the cluster data with specific r. With a small r the clusters
%overlap each other and with a large r the clusters are well separated. N
%determines the number of data points to generate and D the dimensionalty
%of the data. Netlab library is required to be installed.
%Copyright (C) 2008-2010 Mikael Kuusela.

path(path, '../netlab');

%Five clusters, r specifies the location of cluster centers
if D >= 2
    mix = gmm(D,5,'spherical');
    mix.covars = [0.03 0.03 0.03 0.03 0.03];
    mix.priors = [0.2 0.2 0.2 0.2 0.2];
    mix.centres(1,:) = repmat(0, [1 D]);
    mix.centres(2,:) = repmat(r, [1 D]);
    mix.centres(3,:) = repmat(-r, [1 D]);        
    mix.centres(4,:) = repmat(r, [1 D]);
    mix.centres(5,:) = repmat(-r, [1 D]);
    mix.centres(4,2) = -mix.centres(4,2);
    mix.centres(5,2) = -mix.centres(5,2);        
    X = gmmsamp(mix,N)';
else
    error('D must be at least 2');
end
