function c = costFunction(alpha_0, beta_0, v_0, W_0, invW_0, mean_0, res, N_eff, x_avg, S, alpha, beta, mean, v, W, pi_eff, lambda_eff, K, N, D)
%Variational cost for VB-MoG. The function takes model parameters as input
%and returns the corresponding cost.
%Copyright (C) 2008-2010 Mikael Kuusela.

temp = 0;

for n=1:N
    for k=1:K
        temp = temp + res(n,k)*log(res(n,k));
        %temp = temp + res(n,k)*log(res(n,k)+eps);
    end
end

c = temp;
temp = 0;

for k=1:K
    temp = temp + (alpha(k)-alpha_0)*log(pi_eff(k));
end

c = c + temp + ln_dirichlet_C(alpha) - ln_dirichlet_C(repmat(alpha_0, [1 K]));
temp = 0;

for k=1:K
    temp = temp + ln_wishart_B(W(:,:,k),v(k));
end

c = c + temp - K * ln_wishart_B(W_0, v_0);
temp = 0;

for k=1:K
    temp = temp + D*(beta_0/beta(k)-log(beta_0/beta(k))-v(k)-1) + beta_0*v(k)*(mean(:,k)-mean_0)'*W(:,:,k)*(mean(:,k)-mean_0) + v(k)*trace(invW_0*W(:,:,k)) + (v(k)-v_0)*log(lambda_eff(k));
end

c = c + 1/2 * temp;
temp = 0;

for k=1:K
    temp = temp + N_eff(k)*(log(lambda_eff(k)) + 2*log(pi_eff(k)) - D/beta(k) - D*log(2*pi) - v(k)*trace(S(:,:,k)*W(:,:,k)) - v(k)*(x_avg(:,k)-mean(:,k))'*W(:,:,k)*(x_avg(:,k)-mean(:,k)));
end

c = c - 1/2 * temp;