function r = grad_m_gamma(mean_0, beta_0, res, N_eff, x_avg, beta, mean, v, W, pi_eff, lambda_eff, K, N, X, D)
%Calculate the gradient of the variational cost with respect to means and
%gammas.
%Copyright (C) 2008-2010 Mikael Kuusela.

%Components corresponding to means
r1 = zeros(D*K,1);
for k=1:K
    r1((k-1)*D+1:(k-1)*D+D) = v(k)*W(:,:,k)*(N_eff(k)*(mean(:,k)-x_avg(:,k))+beta_0*(mean(:,k)-mean_0));
end

%Components corresponding to gammas
E = grad_E(res, pi_eff, lambda_eff, D, beta, v, X, mean, W, N, K);
F = zeros(1,N);
for i=1:N
    for k=1:K
        F(i) = F(i) + E(i,k);
    end
end    
r2 = zeros(N,K-1);
for i=1:N
    for j=1:(K-1)
        r2(i,j) = E(i,j)-res(i,j)*F(i);        
    end
end
r2 = reshape(r2',[],1);

%Both means and gammas
r = cat(1,r1,r2);