function [dmean, dgamma] = grad_m_gamma_bfgs(mean_0, beta_0, res, N_eff, x_avg, beta, mean, v, W, pi_eff, lambda_eff, K, N, X, D)
%Calculate the gradient of the variational cost with respect to means and
%gammas. This function is identical to grad_m_gamma.m except for the
%gradient output which is more suitable to be used with BFGS.
%Copyright (C) 2008-2010 Mikael Kuusela.

%Components corresponding to means
dmean = zeros(D,K);
for k=1:K
    dmean(:,k) = v(k)*W(:,:,k)*(N_eff(k)*(mean(:,k)-x_avg(:,k))+beta_0*(mean(:,k)-mean_0));
end

%Components corresponding to gammas
E = grad_E(res, pi_eff, lambda_eff, D, beta, v, X, mean, W, N, K);
F = zeros(1,N);
for i=1:N
    for k=1:K
        F(i) = F(i) + E(i,k);
    end
end    
dgamma = zeros(N,K-1);
for i=1:N
    for j=1:(K-1)
        dgamma(i,j) = E(i,j)-res(i,j)*F(i);        
    end
end