function plot_final_MoG(alpha, v, W, mean, beta, K, D, X, cost)
%Plot the MoG model using expectations of the parameters in the
%two-dimensional case.
%Copyright (C) 2008-2010 Mikael Kuusela.

if D == 2
    
    %Mesh for plotting
    [x,y] = meshgrid(-1:0.1:1);
    plotN = size(x,1);

    %Set mixing coefficients and covariances to expected values for plotting
    for k=1:K
        mix(k) = alpha(k)/sum(alpha);
        cov(:,:,k) = inv(v(k)*W(:,:,k));
    end

    plot(X(1,:)',X(2,:)','.k'); %Plot data

    axis equal;    
    axis ([-1 1 -1 1]);

    hold on;

    %Plot the gaussians
    for k=1:K
        %if(mix(k) < 0.02)
        %    continue; %Don't plot components with small mixing coefficients
        %end

        z = zeros(plotN,plotN);
        for i=1:plotN
            for j=1:plotN
                z(i,j) = gauss([x(i,j);y(i,j)],mean(:,k),cov(:,:,k));
            end
        end
        contour(x, y, z, 1, 'b');

        text(-0.8,-0.4-k/10,strcat(num2str(k),': ',num2str(mix(k))),'FontSize',11);
        text(mean(1,k),mean(2,k),num2str(k),'FontSize',11);
    end

    %Plot mean distributions
    for k=1:K
        %if(mix(k) < 0.02)
        %    continue; %Don't plot components with small mixing coefficients
        %end

        z = zeros(plotN,plotN);
        for i=1:plotN
            for j=1:plotN
                z(i,j) = gauss([x(i,j);y(i,j)],mean(:,k),1/beta(k)*cov(:,:,k));
            end
        end
        contour(x, y, z, 1, 'r');
    end

    text(-0.8,0.8,strcat('Cost function value: ',num2str(cost)),'FontSize',11);
    hold off;

    %pause(0.1);          
    
else
    disp('Error: D must be 2 for plotting');
end