# -*- coding: iso-8859-1 -*-
#
# Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
# Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License (included in file License.txt in the
# program package) for more details.
#
# $Id: config.py,v 1.1.1.1 2006/11/23 09:42:07 mha Exp $
#
""" Base configurations.

 Base configurations:

   ica    -- linear ICA model
   srcvar -- two layer model with variance sources r connected to u_s
             (the variance neurons of s)
   obsvar -- one layer model with sources connected to both observations x
             and their variance neurons u_x

 Configuration parameters:

   sdim         -- number of sources s [int]
   rdim         -- number of variance sources r [int]
   sblock       -- model for sources [class]
   smap         -- mapping from s to x (and ux) [class]
   rblock       -- model for variancesources [class]
   rmap         -- mapping from r to other parts [class]
   useux        -- use variance neurons for x [bool]
   stox         -- connection from s to x [bool]
   stoux        -- connection from s to ux [bool]
   rtos         -- connection from r to s [bool]
   rtous        -- connection from r to us [bool]
   rtox         -- connection from r to x [bool]
   rtoux        -- connection from r to ux [bool]
   iters        -- number of iterations [int]
   srclayer     -- when to add source layer [int]
   varlayer     -- when to add variance source layer [int]
   printcost    -- how often to print cost [int]
   prune        -- when to start pruning of weights [int]
   prunefreq    -- how often to prune weights [int]
   prunecost    -- how big rise in cost is allowed due to pruning [float]
   add          -- when to start adding weights [int]
   addfreq      -- how often to try adding weights [int]
   addcost      -- how big rise in cost is allowed due to addition [float]
   sdecay       -- number of iterations the source inits decay [int]
   rdecay       -- number of iterations the variance source inits decay [int]
   rotater      -- (experimental)
   clampwithvar -- clamp data with variance [float]

 Default for all is None

 Pseudoparameters:

   base -- uses values from another configuration
   file -- reads parameter values from a file, useful for using
           saved configurations, works only as a commandline switch
"""

import blocks

# base configurations: ica, twolayerica (exp.), srcvar, obsvar

configs = {
    "default":
    {"iters": 1000, "srclayer": 5, "varlayer": 250, "printcost": 10,
     "prune": 1100, "prunefreq": 200, "prunecost": 0,
     "add": 1200, "addfreq": 200, "addcost": 0,
     "sdecay": 10, "rdecay": 200},
    "ica":
    {"base": "default",
     "sblock": blocks.Ica, "smap": blocks.LinearMap, "stox": 1},
    "srcvar":
    {"base": "ica",
     "rblock": blocks.DynIca, "rmap": blocks.BiasedLinearMap, "rtous": 1},
    "obsvar":
    {"base": "ica",
     "smap": blocks.BiasedLinearMap, "useux": 1, "stoux": 1},
    }

