// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: MatArray.h 5 2006-10-26 09:44:54Z ah $

#ifndef MATARRAY_H
#define MATARRAY_H

#include "Templates.h"
#ifdef WITH_MATLAB
#include <matrix.h>
#include <mat.h>

class MatArray
{
public:
  MatArray() {
    array = NULL;
  }

  ~MatArray() {
    mxDestroyArray(array);
  }

  DV ExtractDV(size_t col) {
    size_t len = Size(1);

    if (col >= Size(2))
      throw IndexException();

    DV res(len);

    double *pr = mxGetPr(array);
    for (size_t i=0; i<len; i++)
      res[i] = pr[i + col*len];

    return res;
  }

  void LoadFromFile(string file, string arrayname) {
    MATFile *fp;

    fp = matOpen(file.c_str(), "r");
    if (! fp)
      throw MatlabException("Error in loading .mat file!");

#ifndef __OLD_MATLAB__
    array = matGetVariable(fp, arrayname.c_str());
#else
    array = matGetArray(fp, arrayname.c_str());
#endif

    if (! array)
      throw MatlabException("Bad variable name when loading .mat file!");

    matClose(fp);
  }

  size_t Size(int n) {
    if (array == NULL)
      return 0;
    switch (n) {
    case 1:
      return mxGetM(array);
    case 2:
      return mxGetN(array);
    default:
      return 0;
    }
  }

private:
  mxArray *array;
};
#else
class MatArray
{
public:
  MatArray() {
    throw MatlabException("No Matlab support in this library version");
  }
  ~MatArray() {
    throw MatlabException("No Matlab support in this library version");
  }
  DV ExtractDV(size_t col) {
    throw MatlabException("No Matlab support in this library version");
  }
  void LoadFromFile(string file, string arrayname) {
    throw MatlabException("No Matlab support in this library version");
  }
  size_t Size(int n) {
    throw MatlabException("No Matlab support in this library version");
  }
};
#endif // WITH_MATLAB

#endif // MATARRAY_H
