// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: MatlabLoader.h 5 2006-10-26 09:44:54Z ah $

#ifndef MATLABLOADER_H
#define MATLABLOADER_H

#include "Templates.h"
#ifdef WITH_MATLAB
#include "Loader.h"
#include <matrix.h>
#include <mat.h>


/**********************************
 **  Class MatlabLoader
 */
class MatlabLoader : public ConcreteLoader
{
public:
  MatlabLoader(string _filename, string _varname);
  virtual ~MatlabLoader();

  virtual void LoadIt();

  virtual int    StartEnumeratedContainer(string name);
  virtual int    StartNamedContainer(string name);
  virtual void   CloseEnumeratedContainer(string name);
  virtual void   CloseNamedContainer(string name);

  virtual int    StartNode(string & type);
  virtual void   CloseNode(string type);

  virtual int GetDouble(double & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    val = ToDouble(mar); 
    return(1);
  }
  virtual int GetInt   (int    & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    val = ToInt(mar); 
    return(1);
  }
  virtual int GetBool  (bool   & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    val = ToBool(mar); 
    return(1);
  }
  virtual int GetString(string & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    val = ToString(mar);
    return(1);
  }

  virtual int GetLabel (Label  & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToLabel( mar, val ); 
    return(1);
  }
  virtual int GetDV    (DV     & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToDV( mar, val );
    return(1);
  }
  virtual int GetDFlags(DFlags & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToDFlags( mar, val );
    return(1);
  }
  virtual int GetDSSet (DSSet  & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToDSSet( mar, val );
    return(1);
  }
  virtual int GetDVSet (DVSet  & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToDVSet( mar, val );
    return(1);
  }
  virtual int GetDVH   (DVH    & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToDVH( mar, val );
    return(1);
  }
  virtual int GetDD    (DD     & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToDD( mar, val );
    return(1);
  }
  virtual int GetVDD   (VDD    & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToVDD( mar, val );
    return(1);
  }
  virtual int GetIntV  (IntV   & val)
  {
    mxArray *mar;
    if( !GetArray(&mar) )  return(0);
    ToIntV( mar, val );
    return(1);
  }

  /********************************
   **  Named
   */
  virtual int GetNamedDouble(string name, double & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    val = ToDouble(mar);
    return(1);
  }
  virtual int GetNamedInt   (string name, int    & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    val = ToInt(mar);
    return(1);
  }

  virtual int GetNamedBool  (string name, bool   & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    val = ToBool(mar);
    return(1);
  }

  virtual int GetNamedString(string name, string & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    val = ToString(mar);
    return(1);
  }

  virtual int GetNamedLabel (string name, Label  & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToLabel( mar, val );
    return(1);
  }

  virtual int GetNamedDV    (string name, DV     & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToDV( mar, val ); return(1);
  }

  virtual int GetNamedDFlags(string name, DFlags & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToDFlags( mar, val ); return(1);
  }

  virtual int GetNamedDSSet (string name, DSSet  & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToDSSet( mar, val ); return(1);
  }

  virtual int GetNamedDVSet (string name, DVSet  & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToDVSet( mar, val ); return(1);
  }

  virtual int GetNamedDVH   (string name, DVH    & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToDVH( mar, val ); return(1);
  }

  virtual int GetNamedDD    (string name, DD     & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToDD( mar, val ); return(1);
  }

  virtual int GetNamedVDD   (string name, VDD    & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToVDD( mar, val ); return(1);
  }

  virtual int GetNamedIntV  (string name, IntV   & val)
  {
    mxArray *mar;
    if( !GetNamedArray(name, &mar) )  return(0);
    ToIntV( mar, val ); return(1);
  }

private:
  bool GetNamedArray(string name, mxArray **mar);
  bool GetArray(mxArray **mar);

  double ToDouble(mxArray *mar) { return mxGetScalar(mar); }
  int    ToInt   (mxArray *mar) { return (int)mxGetScalar(mar); }
  bool   ToBool  (mxArray *mar) { return (bool)mxGetScalar(mar); }
  // is a boolean stored as (bool *) in Matlab???!?!?
  string ToString(mxArray *mar);

  void   ToLabel (mxArray *mar, Label  & val);
  void   ToDV    (mxArray *mar, DV     & val);
  void   ToDFlags(mxArray *mar, DFlags & val);
  void   ToDSSet (mxArray *mar, DSSet  & val);
  void   ToDVSet (mxArray *mar, DVSet  & val);
  void   ToDVH   (mxArray *mar, DVH    & val);
  void   ToDD    (mxArray *mar, DD     & val);
  void   ToVDD   (mxArray *mar, VDD    & val);
  void   ToIntV  (mxArray *mar, IntV   & val);

  vector<mxArray *> open_cont;        // OPEN CONTainers
  vector<int>       ec_ix;            // Enumerated Container's
                                      //  IndeX

  enum last_container_types { NONE, NAMED, ENUMER };
  vector<last_container_types> last;
  mxArray * root_node;
  bool    saved;

  string            fname;            // File name
  string            varname;          // Variable name
};
#endif // WITH_MATLAB

#endif // MATLABLOADER_H

/*
**  End of MatlabLoader.h
*/
