// -*- C++ -*-

//
// This file is a part of the Bayes Blocks library
//
// Copyright (C) 2001-2006 Markus Harva, Antti Honkela, Alexander
// Ilin, Tapani Raiko, Harri Valpola and Tomas stman.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License (included in file License.txt in the
// program package) for more details.
//
// $Id: PythonSaver.h 7 2006-10-26 10:26:41Z ah $

#ifndef PYTHONSAVER_H
#define PYTHONSAVER_H

#include "Templates.h"
#ifdef WITH_PYTHON
#ifndef __PYTHON_H_INCLUDED__
#error "Python.h must be included before this file.  (It must also be included before any system include files.)"
#endif // not __PYTHON_H_INCLUDED

#if PY_VERSION_HEX < 0x02050000 && !defined(PY_SSIZE_T_MIN)
typedef int Py_ssize_t;
#define PY_SSIZE_T_MAX INT_MAX
#define PY_SSIZE_T_MIN INT_MIN
#endif

#include "Saver.h"

class PythonSaver : public ConcreteSaver
{
public:
  PythonSaver(bool _usearray=1);
  virtual ~PythonSaver();

  PyObject *GetTheNet() { return root_node; }

  virtual void SaveIt();

  virtual void StartEnumeratedContainer(int size, string name);
  virtual void StartNamedContainer(string name);
  virtual void CloseEnumeratedContainer(string name);
  virtual void CloseNamedContainer(string name);
  virtual void StartNode(string type);
  virtual void CloseNode(string type);
  virtual void SetDouble(double val) { SetArray(PyFloat_FromDouble(val)); }
  virtual void SetInt(int val) { SetArray(PyInt_FromLong(val)); }
  virtual void SetBool(bool val) { SetArray(PyInt_FromLong(val)); }
  virtual void SetString(string val) { SetArray(PyString_FromString(val.c_str())); }
  virtual void SetLabel(Label val) { SetArray(PyString_FromString(val.c_str())); }
  virtual void SetDV(DV val) { SetArray(DumpDV(val)); }
  virtual void SetDFlags(DFlags val) { SetArray(DumpDFlags(val)); }
  virtual void SetDSSet(DSSet val) { SetArray(DumpDSSet(val)); }
  virtual void SetDVSet(DVSet val) { SetArray(DumpDVSet(val)); }
  virtual void SetDVH(DVH val) { SetArray(DumpDVH(val)); }
  virtual void SetDD(DD val) { SetArray(DumpDD(val)); }
  virtual void SetVDD(VDD val) { SetArray(DumpVDD(val)); }
  virtual void SetIntV(IntV val) { SetArray(DumpIntV(val)); }
  virtual void SetNamedDouble(string name, double val) {
    SetNamedArray(name, PyFloat_FromDouble(val));
  }
  virtual void SetNamedInt(string name, int val) {
    SetNamedArray(name, PyInt_FromLong(val));
  }
  virtual void SetNamedBool(string name, bool val) {
    SetNamedArray(name, PyInt_FromLong(val));
  }
  virtual void SetNamedString(string name, string val) {
    SetNamedArray(name, PyString_FromString(val.c_str()));
  }
  virtual void SetNamedLabel(string name, Label val) {
    SetNamedArray(name, PyString_FromString(val.c_str()));
  }
  virtual void SetNamedDV(string name, DV val) {
    SetNamedArray(name, DumpDV(val));
  }
  virtual void SetNamedDFlags(string name, DFlags val) {
    SetNamedArray(name, DumpDFlags(val));
  }
  virtual void SetNamedDSSet(string name, DSSet val) {
    SetNamedArray(name, DumpDSSet(val));
  }
  virtual void SetNamedDVSet(string name, DVSet val) {
    SetNamedArray(name, DumpDVSet(val));
  }
  virtual void SetNamedDVH(string name, DVH val) {
    SetNamedArray(name, DumpDVH(val));
  }
  virtual void SetNamedDD(string name, DD val) {
    SetNamedArray(name, DumpDD(val));
  }
  virtual void SetNamedVDD(string name, VDD val) {
    SetNamedArray(name, DumpVDD(val));
  }
  virtual void SetNamedIntV(string name, IntV val) {
    SetNamedArray(name, DumpIntV(val));
  }

private:
  void SetNamedArray(string name, PyObject *val);
  void SetArray(PyObject *val);
  PyObject *DumpDFlags(const DFlags f);
  PyObject *DumpDSSet(const DSSet f);
  PyObject *DumpDV(const DV f) {
    if (usearray)
      return DumpDV_array(f);
    else
      return DumpDV_list(f);
  }
  PyObject *DumpDV_list(const DV f);
  PyObject *DumpDV_array(const DV f);
  PyObject *DumpDVSet(const DVSet f);
  PyObject *DumpDVH(const DVH f);
  PyObject *DumpDD(const DD f);
  PyObject *DumpVDD(const VDD f);
  PyObject *DumpIntV(const IntV f);
  PyObject *DumpLabel(const Label f);

  vector<PyObject *> open_named_containers;
  vector<PyObject *> open_enum_containers;
  vector<Py_ssize_t> enum_container_indices;
  enum last_container_types { NONE, NAMED, ENUMER };
  vector<last_container_types> last;
  PyObject *root_node;
  bool saved;
  bool usearray;
};

#endif // WITH_PYTHON
#endif // PYTHONSAVER_H
